#ifndef ABSTRACTPLAYLISTLISTMODEL_H
#define ABSTRACTPLAYLISTLISTMODEL_H

#include "playlistitem.h"
#include <QAbstractListModel>
#include <QSharedPointer>

#ifndef QML_USER_INTERFACE
class ThumbnailCache;
#endif

class AbstractPlaylistListModel : public QAbstractListModel
{
    Q_OBJECT

public:
    enum Roles {
        IdRole = Qt::UserRole + 1,
        PlaylistIdRole,
        TitleRole,
        ArtistRole,
        ArtistAvatarUrlRole,
        DateRole,
        VideoCountRole,
#ifndef QML_USER_INTERFACE
        ThumbnailRole,
#endif
        ThumbnailUrlRole,
        LargeThumbnailUrlRole,
        DescriptionRole
    };

public:
    explicit AbstractPlaylistListModel(QObject *parent = 0);
    ~AbstractPlaylistListModel();
    int rowCount(const QModelIndex &parent = QModelIndex()) const;
    QVariant data(const QModelIndex &index, int role) const;
    Q_INVOKABLE QVariant data(int row, const QByteArray &role) const;
    QSharedPointer<PlaylistItem> get(int row) const;
#ifdef QML_USER_INTERFACE
    Q_INVOKABLE PlaylistItem* getFromQML(int row) const;
#endif

public slots:
    void clear();
    void insertPlaylist(int row, QSharedPointer<PlaylistItem> playlist);
    void appendPlaylist(QSharedPointer<PlaylistItem> playlist);
    bool removePlaylist(const QVariant &value, int role = PlaylistIdRole);
    
protected:
    bool removeRow(int row, const QModelIndex &parent = QModelIndex());

#ifndef QML_USER_INTERFACE
protected slots:
    void onThumbnailReady();
#endif

protected:
#ifndef QML_USER_INTERFACE
    ThumbnailCache *m_cache;
#endif
    QList< QSharedPointer<PlaylistItem> > m_list;
};

#endif // ABSTRACTPLAYLISTLISTMODEL_H
