#ifndef YOUTUBE_H
#define YOUTUBE_H

#include <QObject>
#include <QUrl>
#include <QString>

class QNetworkAccessManager;
class QNetworkReply;

class YouTube : public QObject {
    Q_OBJECT

public:
    explicit YouTube(QObject *parent = 0);
    ~YouTube();
    inline QNetworkAccessManager* networkAccessManager() const { return m_nam; }
    inline void setNetworkAccessManager(QNetworkAccessManager *manager) { m_nam = manager; }
    inline QString username() const { return m_user; }
    inline bool userSignedIn() const { return !accessToken().isEmpty(); }
    QNetworkReply* createReply(QUrl url);

public slots:
    void setAccount(const QString &user = QString(), const QString &token = QString(), const QString &refresh = QString());
    inline void setUsername(const QString &user) { m_user = user; emit usernameChanged(user); }
    void refreshAccessToken();

private slots:
    void checkTokenRefresh();

private:
    inline QString accessToken() const { return m_token; }
    inline void setAccessToken(const QString &token) { m_token = token; emit userSignedInChanged(); }
    inline QString refreshToken() const { return m_refresh_token; }
    inline void setRefreshToken(const QString &token) { m_refresh_token = token; }

signals:
    void usernameChanged(const QString &username);
    void userSignedInChanged();
    void newAccountSet();
    void accessTokenRefreshed(const QString &token);
    void refreshError();

private:
    QNetworkAccessManager *m_nam;
    QString m_client_id;
    QString m_client_secret;
    QString m_user;
    QString m_token;
    QString m_refresh_token;
};

#endif // YOUTUBE_H
