#include "youtube.h"
#include "json.h"
#include <QNetworkAccessManager>
#include <QNetworkRequest>
#include <QNetworkReply>

using namespace QtJson;

YouTube::YouTube(QObject *parent) :
    QObject(parent),
    m_nam(0),
    m_client_id("446197852855.apps.googleusercontent.com"),
    m_client_secret("YzuBGnTyRdz9cK5J3Pg5Xlte")
{
}

YouTube::~YouTube() {
}

QNetworkReply* YouTube::createReply(QUrl url) {
    url.addQueryItem("access_token", accessToken());
    QNetworkRequest request(url);
    request.setRawHeader("User-Agent", "cuteTube/1.3.2 (Nokia; Qt)");

    return networkAccessManager()->get(request);
}

void YouTube::setAccount(const QString &user, const QString &token, const QString &refresh) {
    if (user != username()) {
        setUsername(user);
    }

    setAccessToken(token);
    setRefreshToken(refresh);

    if ((user.isEmpty()) && (!token.isEmpty())) {
        emit newAccountSet();
    }
}

void YouTube::refreshAccessToken() {
    QUrl url("https://accounts.google.com/o/oauth2/token");

    QByteArray body("client_id=" + m_client_id.toUtf8() +
                    "&client_secret=" + m_client_secret.toUtf8() +
                    "&refresh_token=" + refreshToken().toUtf8() +
                    "&grant_type=refresh_token");

    QNetworkRequest request(url);
    request.setRawHeader("User-Agent", "cuteTube/1.3.2 (Nokia; Qt)");
    request.setHeader(QNetworkRequest::ContentTypeHeader, "application/x-www-form-urlencoded");
    QNetworkReply *reply = networkAccessManager()->post(request, body);
    connect(reply, SIGNAL(finished()), this, SLOT(checkTokenRefresh()));
}

void YouTube::checkTokenRefresh() {
    QNetworkReply* reply = qobject_cast<QNetworkReply*>(sender());

    if (!reply) {
        emit refreshError();
        return;
    }

    QString response(reply->readAll());
    bool ok;
    QVariantMap result = Json::parse(response, ok).toMap();

    if (!ok) {
        emit refreshError();
    }
    else {
        QString token = result.value("access_token").toString();

        if (token.isEmpty()) {
            QString error = result.value("error").toString();

            if (error == "invalid_request") {
                emit refreshError();
                setAccount();
            }
            else {
                emit refreshError();
            }
        }
        else {
            setAccessToken(token);
            emit accessTokenRefreshed(token);
        }
    }

    reply->deleteLater();
}
