#ifndef DATABASE_H
#define DATABASE_H

#include <QObject>
#include <QSqlDatabase>

class Database : public QObject {
    Q_OBJECT

public:
    explicit Database(QObject *parent = 0);
    ~Database() {}
    void restoreAccounts();

public slots:
    void initialize();
    bool setYouTubeUsername(const QString &user);
    bool setYouTubeAccessToken(const QString &token);
    bool setDailymotionUsername(const QString &user);
    bool setDailymotionAccessToken(const QString &token, const QString &refresh);

signals:
    void gotYouTubeAccount(const QString &user, const QString &token, const QString &refresh);
    void gotDailymotionAccount(const QString &user, const QString &token, const QString &refresh);
    void databaseError();

private:
    void restoreYouTubeAccount();
    void restoreDailymotionAccount();

private:
    QSqlDatabase m_database;
};

#endif // DATABASE_H
