#ifndef DAILYMOTION_H
#define DAILYMOTION_H

#include <QObject>
#include <QUrl>
#include <QString>

class QNetworkAccessManager;
class QNetworkReply;

class Dailymotion : public QObject {
    Q_OBJECT

public:
    explicit Dailymotion(QObject *parent = 0);
    ~Dailymotion();
    inline QNetworkAccessManager* networkAccessManager() const { return m_nam; }
    void setNetworkAccessManager(QNetworkAccessManager *manager) { m_nam = manager; }
    inline QString username() const { return m_user; }
    inline bool userSignedIn() const { return !accessToken().isEmpty(); }
    QNetworkReply* createReply(QUrl url);

public slots:
    void setAccount(const QString &user = QString(), const QString &token = QString(), const QString &refresh = QString());
    void refreshAccessToken();

private slots:
    void checkTokenRefresh();

private:
    inline QString accessToken() const { return m_token; }
    inline void setUsername(const QString &user) { m_user = user; emit usernameChanged(user); }
    inline void setAccessToken(const QString &token) { m_token = token; emit userSignedInChanged(); }
    inline QString refreshToken() const { return m_refresh_token; }
    inline void setRefreshToken(const QString &token) { m_refresh_token = token; }

signals:
    void usernameChanged(const QString &username);
    void userSignedInChanged();
    void newAccountSet();
    void accessTokenRefreshed(const QString &token, const QString &refresh);
    void refreshError();

private:
    QNetworkAccessManager *m_nam;
    QString m_client_id;
    QString m_client_secret;
    QString m_user;
    QString m_token;
    QString m_refresh_token;
};

#endif // DAILYMOTION_H
