#include "dailymotion.h"
#include "json.h"
#include <QNetworkAccessManager>
#include <QNetworkRequest>
#include <QNetworkReply>

using namespace QtJson;

Dailymotion::Dailymotion(QObject *parent) :
    QObject(parent), m_nam(0), m_client_id("808ed79fa59e10f3952e"), m_client_secret("5753a7aa0fb0772b628d160aabe3da6059f97375")
{
}

Dailymotion::~Dailymotion() {
}

QNetworkReply* Dailymotion::createReply(QUrl url) {
    url.addQueryItem("access_token", accessToken());
    QNetworkRequest request(url);
    request.setRawHeader("User-Agent", "cuteTube/1.3.2 (Nokia; Qt)");

    return networkAccessManager()->get(request);
}

void Dailymotion::setAccount(const QString &user, const QString &token, const QString &refresh) {
    if (user != username()) {
        setUsername(user);
    }

    setAccessToken(token);
    setRefreshToken(refresh);

    if ((user.isEmpty()) && (!token.isEmpty())) {
        emit newAccountSet();
    }
}

void Dailymotion::refreshAccessToken() {
    QUrl url("https://api.dailymotion.com/oauth/token");

    QByteArray body("client_id=" + m_client_id.toUtf8() +
                    "&client_secret=" + m_client_secret.toUtf8() +
                    "&refresh_token=" + refreshToken().toUtf8() +
                    "&grant_type=refresh_token");

    QNetworkRequest request(url);
    request.setRawHeader("User-Agent", "cuteTube/1.3.2 (Nokia; Qt)");
    request.setHeader(QNetworkRequest::ContentTypeHeader, "application/x-www-form-urlencoded");
    QNetworkReply *reply = networkAccessManager()->post(request, body);
    connect(reply, SIGNAL(finished()), this, SLOT(checkTokenRefresh()));
}

void Dailymotion::checkTokenRefresh() {
    QNetworkReply* reply = qobject_cast<QNetworkReply*>(sender());

    if (!reply) {
        emit refreshError();
        return;
    }

    QString response(reply->readAll());
    bool ok;
    QVariantMap result = Json::parse(response, ok).toMap();

    if (!ok) {
        emit refreshError();
    }
    else {
        QString token = result.value("access_token").toString();
        QString refresh = result.value("refresh_token").toString();

        if (token.isEmpty()) {
            emit refreshError();
        }
        else {
            setAccessToken(token);
            setRefreshToken(refresh);
            emit accessTokenRefreshed(token, refresh);
        }
    }
}
