#include "youtubevideoinfowindow.h"
#include "youtubechannelwindow.h"
#include "youtubevideolistwindow.h"
#include <QMenuBar>

YouTubeVideoInfoWindow::YouTubeVideoInfoWindow(Session *session, QSharedPointer<VideoItem> video, QWidget *parent) :
    StackedWindow(session, parent),
    m_video(video),
    m_menu(menuBar()->addMenu("")),
    m_actionGroup(new QActionGroup(this)),
    m_infoAction(new QAction(tr("Info"), this)),
    m_commentsAction(new QAction(tr("Comments"), this)),
    m_relatedAction(new QAction(tr("Related"), this)),
    m_tabWidget(new QStackedWidget(this)),
    m_infoTab(new YouTubeVideoDescriptionTab(m_session, video, this)),
    m_commentsTab(0),
    m_relatedTab(0)
{
    setWindowTitle(tr("Video info"));
    setCentralWidget(m_tabWidget);

    m_infoAction->setCheckable(true);
    m_infoAction->setActionGroup(m_actionGroup);
    m_commentsAction->setCheckable(true);
    m_commentsAction->setActionGroup(m_actionGroup);
    m_relatedAction->setCheckable(true);
    m_relatedAction->setActionGroup(m_actionGroup);
    m_actionGroup->setExclusive(true);

    m_menu->addAction(m_infoAction);
    m_menu->addAction(m_commentsAction);
    m_menu->addAction(m_relatedAction);

    m_infoAction->setChecked(true);

    m_tabWidget->setFrameStyle(QFrame::NoFrame);
    m_tabWidget->addWidget(m_infoTab);

    connect(m_infoAction, SIGNAL(triggered()), this, SLOT(showInfo()));
    connect(m_commentsAction, SIGNAL(triggered()), this, SLOT(showComments()));
    connect(m_relatedAction, SIGNAL(triggered()), this, SLOT(showRelatedVideos()));

    showInfo();
    onOrientationChanged();
}

void YouTubeVideoInfoWindow::clearMenuActions() {
    QList<QAction*> actions = menuBar()->actions();

    for (int i = 1; i < actions.size(); i++) {
        menuBar()->removeAction(actions.at(i));
    }
}

void YouTubeVideoInfoWindow::showInfo() {
    m_tabWidget->setCurrentWidget(m_infoTab);
    setWindowTitle(tr("Info"));
    clearMenuActions();
    menuBar()->addActions(m_infoTab->actions());
}

void YouTubeVideoInfoWindow::showComments() {
    if (!m_commentsTab) {
        m_commentsTab = new YouTubeVideoCommentsTab(m_session, m_video, this);
        m_tabWidget->addWidget(m_commentsTab);
    }

    m_tabWidget->setCurrentWidget(m_commentsTab);
    setWindowTitle(tr("Comments"));
    clearMenuActions();
    menuBar()->addActions(m_commentsTab->actions());
}

void YouTubeVideoInfoWindow::showRelatedVideos() {
    if (!m_relatedTab) {
        m_relatedTab = new YouTubeRelatedVideosTab(m_session, m_video, this);
        m_tabWidget->addWidget(m_relatedTab);
    }

    m_tabWidget->setCurrentWidget(m_relatedTab);
    setWindowTitle(tr("Related videos"));
    clearMenuActions();
    menuBar()->addActions(m_relatedTab->actions());
}
