#include "youtubeplaylistlisttab.h"
#include "youtubeplaylistdelegate.h"
#include "youtubeplaylistvideoswindow.h"

YouTubePlaylistListTab::YouTubePlaylistListTab(Session *session, QWidget *parent) :
    AbstractTab(parent),
    m_session(session),
    m_listView(new ListView(this)),
    m_model(new YouTubePlaylistListModel(m_session, this)),
    m_noResultsLabel(new QLabel(QString("<p style='color:#4d4d4d;font-size:40px;'><center><b>%1</b></center></p>").arg(tr("No playlists found")), this)),
    m_grid(new QGridLayout(this))
{
    m_grid->setContentsMargins(0, 0, 0, 0);
    m_grid->addWidget(m_listView, 0, 0);
    m_listView->setModel(m_model);
    m_listView->setItemDelegate(new YouTubePlaylistDelegate(m_listView));
    m_noResultsLabel->hide();

    connect(m_model, SIGNAL(loadingChanged()), this, SLOT(onLoadingChanged()));
    connect(m_listView, SIGNAL(clicked(QModelIndex)), this, SLOT(onItemClicked(QModelIndex)));
    connect(m_listView, SIGNAL(atEnd()), m_model, SLOT(getMorePlaylists()));

    onOrientationChanged();
}

void YouTubePlaylistListTab::setPlaylistFeed(const QString &feed) {
    m_model->getPlaylists(feed);
}

void YouTubePlaylistListTab::setLandscapeLayout() {
    m_noResultsLabel->setFixedSize(800, 400);
}

void YouTubePlaylistListTab::setPortraitLayout() {
    m_noResultsLabel->setFixedSize(480, 700);
}

void YouTubePlaylistListTab::onLoadingChanged() {
    m_session->toggleBusy(m_model->loading());
    m_noResultsLabel->setVisible((!m_model->loading()) && (m_model->rowCount() == 0));
}

void YouTubePlaylistListTab::onItemClicked(const QModelIndex &index) {
    if (index.isValid()) {
        showPlaylist(m_model->get(index.row()));
    }
}

void YouTubePlaylistListTab::showPlaylist(QSharedPointer<PlaylistItem> playlist) {
    YouTubePlaylistVideosWindow *window = new YouTubePlaylistVideosWindow(m_session, playlist, m_session->currentWindow());
    window->show();
}
