#ifndef YOUTUBEPLAYLISTLISTMODEL_H
#define YOUTUBEPLAYLISTLISTMODEL_H

#include "abstractplaylistlistmodel.h"
#include "session.h"

class YouTubePlaylistListModel : public AbstractPlaylistListModel
{
    Q_OBJECT

public:
    explicit YouTubePlaylistListModel(Session *session, QObject *parent = 0);
    inline QString feed() const { return m_feed; }
    void setFeed(const QString &afeed);
    inline bool loading() const { return m_loading; }

public slots:
    void getPlaylists(const QString &afeed = QString());
    void getMorePlaylists();
    void search(const QString &query = QString(), Queries::QueryOrder order = Queries::Relevance);

private slots:
    void addPlaylists();
    inline void onError() { setError(true); setLoading(false); }

private:
    inline QString query() const { return m_query; }
    inline void setQuery(const QString &query) { m_query = query; }
    inline Queries::QueryOrder order() const { return m_order; }
    inline void setOrder(Queries::QueryOrder order) { m_order = order; }
    inline void setLoading(bool loading) { m_loading = loading; emit loadingChanged(); }
    inline bool moreResults() const { return m_moreResults; }
    inline void setMoreResults(bool more) { m_moreResults = more; }
    inline int offset() const { return m_offset; }
    inline void setOffset(int offset) { m_offset = offset; }
    inline bool error() const { return m_error; }
    inline void setError(bool error) { m_error = error; }

signals:
    void loadingChanged();

private:
    Session *m_session;
    QString m_feed;
    QString m_query;
    Queries::QueryOrder m_order;
    bool m_loading;
    bool m_moreResults;
    bool m_error;
    int m_offset;
};

#endif // YOUTUBEPLAYLISTLISTMODEL_H
