#include "youtubeplaylistlistmodel.h"
#include "feedurls.h"
#include <QtNetwork/QNetworkReply>
#include <QtNetwork/QNetworkRequest>

YouTubePlaylistListModel::YouTubePlaylistListModel(Session *session, QObject *parent) :
    AbstractPlaylistListModel(session->newThumbnailCache(), parent),
    m_session(session),
    m_moreResults(true),
    m_error(false),
    m_offset(1)
{
}

void YouTubePlaylistListModel::setFeed(const QString &afeed) {
    m_feed = afeed + "&fields=" + YOUTUBE_PLAYLIST_FIELDS;
}

void YouTubePlaylistListModel::getPlaylists(const QString &afeed) {
    if (!afeed.isEmpty()) {
        setFeed(afeed);
    }

    setLoading(true);
    QNetworkReply *reply = m_session->youtube()->createReply(feed(), offset());
    connect(reply, SIGNAL(finished()), this, SLOT(addPlaylists()));
}

void YouTubePlaylistListModel::search(const QString &aquery, Queries::QueryOrder anorder) {
    if (!aquery.isEmpty()) {
        setQuery(aquery);
        setOrder(anorder);
    }

    setLoading(true);
    QNetworkReply *reply = m_session->youtube()->createSearchReply(Queries::Playlists, query(), offset(), order());
    connect(reply, SIGNAL(finished()), this, SLOT(addPlaylists()));
}

void YouTubePlaylistListModel::addPlaylists() {
    QNetworkReply *reply = qobject_cast<QNetworkReply*>(sender());

    if (!reply) {
        setLoading(false);
        setError(true);
        return;
    }

    int statusCode = reply->attribute(QNetworkRequest::HttpStatusCodeAttribute).toInt();

    if (statusCode == 401) {
        connect(m_session->youtube(), SIGNAL(accessTokenRefreshed(QString)), this, SLOT(getPlaylists()));
        connect(m_session->youtube(), SIGNAL(refreshError()), this, SLOT(onError()));
        m_session->youtube()->refreshAccessToken();
    }
    else {
        QDomDocument doc;
        doc.setContent(reply->readAll());
        QDomNodeList entries = doc.elementsByTagName("entry");

        for (int i = 0; i < entries.count(); i++) {
            appendPlaylist(QSharedPointer<PlaylistItem>(new PlaylistItem(entries.at(i))));
        }

        setLoading(false);
        int totalResults = doc.namedItem("feed").firstChildElement("openSearch:totalResults").text().toInt();
        setMoreResults((totalResults > rowCount()) && (!entries.isEmpty()));
        setOffset(offset() + 30);

        disconnect(m_session->youtube(), SIGNAL(accessTokenRefreshed(QString)), this, SLOT(getPlaylists()));
        disconnect(m_session->youtube(), SIGNAL(refreshError()), this, SLOT(onError()));
    }

    reply->deleteLater();
}

void YouTubePlaylistListModel::getMorePlaylists() {
    if ((moreResults()) && (!loading())) {
        if (!query().isEmpty()) {
            search();
        }
        else {
            getPlaylists();
        }
    }
}
