#ifndef YOUTUBEACCOUNTSLISTMODEL_H
#define YOUTUBEACCOUNTSLISTMODEL_H

#include "youtube.h"
#include "cookiejar.h"
#include <QSqlTableModel>

class YouTubeAccountsListModel : public QSqlTableModel
{
    Q_OBJECT

public:
    enum Roles {
        DisplayNameRole = Qt::DisplayRole,
        UsernameRole,
        AccessTokenRole,
        RefreshTokenRole,
        CookiesRole,
        ActiveRole
    };

public:
    explicit YouTubeAccountsListModel(YouTube *youtube, CookieJar *cookieJar, QObject *parent = 0);
    ~YouTubeAccountsListModel();
    QVariant data(const QModelIndex &idx, int role) const;

public slots:
    void switchAccount(int row);
    void addAccount(const QString &displayName, const QString &token, const QString &refresh);
    void deleteAccount(int row);

private:
    void setActiveAccount(int row);

signals:
    void accountSelected(const QString &user, const QString &token, const QString &refresh);
    void accountAdded(const QString &user, const QString &token, const QString &refresh);
    void accountDeleted();
    void gotCookies(const QByteArray &cookieString);
    void alert(const QString &message);
    void info(const QString &message);
    void warning(const QString &message);

private:
    YouTube *m_youtube;
    CookieJar *m_jar;
};

#endif // YOUTUBEACCOUNTSLISTMODEL_H
