#include "videoserviceselector.h"

VideoServiceSelector::VideoServiceSelector(const QString &text, QWidget *parent) :
    QMaemo5ValueButton(text, parent),
    m_model(new VideoServiceModel(this)),
    m_selector(new QMaemo5ListPickSelector(this))
{
    m_selector->setModel(m_model);
    m_selector->setModelColumn(0);
    setPickSelector(m_selector);
    connect(m_selector, SIGNAL(selected(QString)), this, SLOT(onSelected()));
}

void VideoServiceSelector::setValue(Services::VideoService value) {
    bool found = false;
    int i = 0;

    while ((!found) && (i < m_model->rowCount())) {
        found = static_cast<Services::VideoService>(m_model->value(i).toInt()) == value;

        if (found) {
            m_selector->setCurrentIndex(i);
        }

        i++;
    }

    if (!found) {
        m_selector->setCurrentIndex(0);
    }
}

Services::VideoService VideoServiceSelector::currentValue() {
    return static_cast<Services::VideoService>(m_model->value(m_selector->currentIndex()).toInt());
}

void VideoServiceSelector::onSelected() {
    emit valueChanged(currentValue());
}

void VideoServiceSelector::showExtras(bool show) {
    m_model->showExtras(show);
}

void VideoServiceSelector::showXTube(bool show) {
    m_model->showXTube(show);
}
