#ifndef VIDEOPLAYBACKWINDOW_H
#define VIDEOPLAYBACKWINDOW_H

#include "stackedwindow.h"
#include "videowidget.h"
#include "videocontrols.h"
#include <QShowEvent>
#include <QHideEvent>
#include <QKeyEvent>

class VideoPlaybackWindow : public StackedWindow
{
    Q_OBJECT

public:
    explicit VideoPlaybackWindow(Session *session, QList< QSharedPointer<VideoItem> > playlist, QWidget *parent = 0);
    ~VideoPlaybackWindow();

protected:
    void showEvent(QShowEvent *event);
    void hideEvent(QHideEvent *event);
    void keyPressEvent(QKeyEvent *event);

private slots:
    void toggleControls();
    
private:
    ScreenOrientation::Orientation m_oldOrientation;
    VideoWidget *m_videoWidget;
    QMediaPlayer *m_player;
    VideoControls *m_controls;
};

#endif // VIDEOPLAYBACKWINDOW_H
