#ifndef VIDEOLISTDELEGATE_H
#define VIDEOLISTDELEGATE_H

#include <QStyledItemDelegate>
#include <QPainter>
#include <QListView>

class VideoListDelegate : public QStyledItemDelegate
{
    Q_OBJECT

public:
    explicit VideoListDelegate(QListView *parent);
    void paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const;
    bool editorEvent(QEvent *event, QAbstractItemModel *model, const QStyleOptionViewItem &option, const QModelIndex &index);
    QSize sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const;

signals:
    void clicked(const QModelIndex &index);
    void play(const QModelIndex &index);

private:
    QListView *m_view;
    bool m_thumbnailPressed;
};

#endif // VIDEOLISTDELEGATE_H
