#include "socialvideolistmodel.h"

SocialVideoListModel::SocialVideoListModel(Session *session, QObject *parent) :
    AbstractVideoListModel(session->newThumbnailCache(), parent),
    m_session(session)
{
    m_session->sharing()->getVideos();
    connect(m_session->sharing(), SIGNAL(videoAddedToCache(int)), this, SLOT(onVideoAdded(int)));
}

void SocialVideoListModel::onVideoAdded(int row) {
    beginInsertRows(QModelIndex(), row, row);
    endInsertRows();
}

int SocialVideoListModel::rowCount(const QModelIndex &parent) const {
    Q_UNUSED(parent);

    return m_session->sharing()->videos()->size();
}

QVariant SocialVideoListModel::data(const QModelIndex &index, int role) const {
    switch (role) {
    case IdRole:
        return m_session->sharing()->videos()->at(index.row()).data()->id();
    case VideoIdRole:
        return m_session->sharing()->videos()->at(index.row()).data()->videoId();
    case TitleRole:
        return m_session->sharing()->videos()->at(index.row()).data()->title();
    case ArtistRole:
        return m_session->sharing()->videos()->at(index.row()).data()->artist();
    case DateRole:
        return m_session->sharing()->videos()->at(index.row()).data()->date();
    case DurationRole:
        return m_session->sharing()->videos()->at(index.row()).data()->duration();
    case ViewCountRole:
        return m_session->sharing()->videos()->at(index.row()).data()->viewCount();
    case RatingCountRole:
        return m_session->sharing()->videos()->at(index.row()).data()->ratingCount();
    case RatingRole:
        return m_session->sharing()->videos()->at(index.row()).data()->rating();
    case ThumbnailRole:
        return m_cache->thumbnail(m_session->sharing()->videos()->at(index.row()).data()->thumbnailUrl(), QSize(160, 120));
    case ServiceRole:
        return m_session->sharing()->videos()->at(index.row()).data()->service();
    case CheckedRole:
        return m_session->sharing()->videos()->at(index.row()).data()->checked();
    default:
        return QVariant();
    }
}

void SocialVideoListModel::toggleChecked(int row) {
    QSharedPointer<VideoItem> video = get(row);
    video.data()->toggleChecked();

    if (video.data()->checked()) {
        m_checkedRows.append(row);
    }
    else {
        m_checkedRows.removeAll(row);
    }

    emit dataChanged(index(row), index(row));
}

void SocialVideoListModel::checkAll() {
    for (int i = 0; i < m_session->sharing()->videos()->size(); i++) {
        get(i)->setChecked(true);
        m_checkedRows.append(i);
    }

    emit dataChanged(index(0), index(m_session->sharing()->videos()->size() - 1));
}

void SocialVideoListModel::checkNone() {
    for (int i = 0; i < m_session->sharing()->videos()->size(); i++) {
        get(i).data()->setChecked(false);
    }

    m_checkedRows.clear();

    if (!m_session->sharing()->videos()->isEmpty()) {
        emit dataChanged(index(0), index(m_session->sharing()->videos()->size() - 1));
    }
}

QList< QSharedPointer<VideoItem> > SocialVideoListModel::checkedItems() {
    QList< QSharedPointer<VideoItem> > checked;

    for (int i = 0; i < m_checkedRows.size(); i++) {
        checked.append(get(m_checkedRows.at(i)));
    }

    return checked;
}
