#ifndef SESSION_H
#define SESSION_H

#include "settings.h"
#include "database.h"
#include "videolauncher.h"
#include "playbacklistmodel.h"
#include "transferlistmodel.h"
#include "youtube.h"
#include "dailymotion.h"
#include "vimeo.h"
#include "xtube.h"
#include "sharing.h"
#include "urlgrabber.h"
#include "transferworker.h"
#include "cookiejar.h"
#include "thumbnaildownloader.h"
#include "thumbnailcache.h"
#include <QObject>
#include <QThread>
#include <QProgressDialog>

class Session : public QObject
{
    Q_OBJECT

public:
    explicit Session(QObject *parent = 0);
    ~Session();
    inline Settings *settings() const { return m_settings; }
    inline Database *database() const { return m_database; }
    inline VideoLauncher *videoLauncher() const { return m_launcher; }
    inline PlaybackListModel *playbackQueue() const { return m_queue; }
    inline TransferListModel *transferManager() const { return m_transferManager; }
    inline TransferWorker *transferWorker() const { return m_transferWorker; }
    inline YouTube *youtube() const { return m_youtube; }
    inline Dailymotion *dailymotion() const { return m_dailymotion; }
    inline Vimeo *vimeo() const { return m_vimeo; }
    inline XTube *xtube() const { return m_xtube; }
    inline Sharing *sharing() const { return m_sharing; }
    inline UrlGrabber *urlGrabber() const { return m_grabber; }
    inline CookieJar *cookieJar() const { return m_jar; }
    inline ThumbnailDownloader *thumbnailDownloader() const { return m_thumbnailDownloader; }
    inline ThumbnailCache *thumbnailCache() const { return m_thumbnailCache; }
    ThumbnailCache *newThumbnailCache();
    inline QNetworkAccessManager *networkAccessManager() const { return m_nam; }
    QWidget* currentWindow() const;

public slots:
    void showInfoBanner(const QString &message);
    void showNoteBanner(const QString &message);
    void showProgressDialog(const QString &message, int numberOfOperations);
    void toggleBusy(bool busy) const;
    void addWindowToStack(QWidget *window);
    void removeWindowFromStack(QObject *window);
    void unwindWindowStack();
    void preventDisturb(bool prevent);

private slots:
    void onMediaPlayerChanged(const QString &player);
    
private:
    Settings *m_settings;
    Database *m_database;
    VideoLauncher *m_launcher;
    TransferListModel *m_transferManager;
    TransferWorker *m_transferWorker;
    YouTube *m_youtube;
    Dailymotion *m_dailymotion;
    Vimeo *m_vimeo;
    XTube *m_xtube;
    Sharing *m_sharing;
    UrlGrabber *m_grabber;
    CookieJar *m_jar;
    ThumbnailDownloader *m_thumbnailDownloader;
    QCache<QUrl, Thumbnail> *m_cache;
    ThumbnailCache *m_thumbnailCache;
    QNetworkAccessManager *m_nam;
    QThread *m_thread;
    PlaybackListModel *m_queue;
    QProgressDialog *m_progressDialog;
    QList<QWidget*> m_windowStack;
};

#endif // SESSION_H
