#ifndef SEARCHTIMESELECTOR_H
#define SEARCHTIMESELECTOR_H

#include "selectionmodels.h"
#include <QMaemo5ValueButton>
#include <QMaemo5ListPickSelector>

class SearchTimeSelector : public QMaemo5ValueButton
{
    Q_OBJECT

public:
    explicit SearchTimeSelector(const QString &text, QWidget *parent = 0);
    void setValue(Queries::TimeFilter value);
    Queries::TimeFilter currentValue();

private slots:
    void onSelected();

signals:
    void valueChanged(Queries::TimeFilter value);

private:
    SearchTimeModel *m_model;
    QMaemo5ListPickSelector *m_selector;
};

#endif // SEARCHTIMESELECTOR_H
