#ifndef PLAYLISTITEM_H
#define PLAYLISTITEM_H

#include <QObject>
#include <QUrl>
#include <QtXml/QDomElement>
#include <QVariantMap>

class PlaylistItem : public QObject
{
    Q_OBJECT

public:
    explicit PlaylistItem(QObject *parent = 0): QObject(parent) {}
    explicit PlaylistItem(const QVariantMap &playlist, QObject *parent = 0);
    explicit PlaylistItem(const QDomNode &playlist, QObject *parent = 0);
    ~PlaylistItem() {}
    inline QString id() const { return m_id; }
    inline void setId(const QString &id) { m_id = id; }
    inline QString playlistId() const { return m_playlistId; }
    inline void setPlaylistId(const QString &id) { m_playlistId = id; }
    inline QString title() const { return m_title; }
    inline void setTitle(const QString &title) { m_title = title; emit titleChanged(); }
    inline QString artist() const { return m_artist; }
    inline void setArtist(const QString &artist) { m_artist = artist; }
    inline QString artistId() const { return m_artistId; }
    inline void setArtistId(const QString &id) { m_artistId = id; }
    inline QUrl artistAvatarUrl() const { return m_artistAvatarUrl; }
    inline void setArtistAvatarUrl(const QUrl &url) { m_artistAvatarUrl = url; }
    inline QString description() const { return m_description; }
    inline void setDescription(const QString &description) { m_description = description; emit descriptionChanged(); }
    inline int duration() const { return m_duration; }
    inline void setDuration(int duration) { m_duration = duration; emit durationChanged(); }
    inline QUrl thumbnailUrl() const { return m_thumbnailUrl; }
    inline void setThumbnailUrl(const QUrl &url) { m_thumbnailUrl = url; }
    inline QString date() const { return m_date; }
    inline void setDate(const QString &date) { m_date = date; }
    inline int videoCount() const { return m_videoCount; }
    inline void setVideoCount(int count) { m_videoCount = count; emit videoCountChanged(); }
    inline bool isPrivate() const { return m_private; }
    inline void setPrivate(bool isPrivate) { m_private = isPrivate; emit isPrivateChanged(); }

signals:
    void titleChanged();
    void descriptionChanged();
    void durationChanged();
    void videoCountChanged();
    void isPrivateChanged();

private:
    QString m_id;
    QString m_playlistId;
    QString m_title;
    QString m_artist;
    QString m_artistId;
    QUrl m_artistAvatarUrl;
    QString m_description;
    int m_duration;
    QString m_date;
    QUrl m_thumbnailUrl;
    int m_videoCount;
    bool m_private;
};

#endif // PLAYLISTITEM_H
