#include "playbacklistdelegate.h"
#include "abstractvideolistmodel.h"

PlaybackListDelegate::PlaybackListDelegate(QObject *parent) :
    QStyledItemDelegate(parent)
{
}

void PlaybackListDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const {
    painter->save();

    if ((option.state) & (QStyle::State_Selected)) {
        painter->drawImage(option.rect, QImage("/etc/hildon/theme/images/TouchListBackgroundPressed.png"));
    }

    QRect titleRect = option.rect;
    titleRect.setLeft(titleRect.left() + 90);
    titleRect.setRight(titleRect.right() - 5);
    titleRect.setTop(titleRect.top() + 5);
    titleRect.setHeight(45);

    QFont smallFont;
    smallFont.setPixelSize(18);
    painter->setFont(smallFont);
    painter->drawText(titleRect, Qt::TextWordWrap, index.data(AbstractVideoListModel::TitleRole).toString());

    QPen newPen(QColor("#4d4d4d"));
    painter->setPen(newPen);

    QRect imageRect = option.rect;
    imageRect.setLeft(imageRect.left() + 5);
    imageRect.setTop(imageRect.top() + 5);
    imageRect.setWidth(80);
    imageRect.setHeight(60);

    Services::VideoService service = static_cast<Services::VideoService>(index.data(AbstractVideoListModel::ServiceRole).toInt());
    QImage image = service == Services::NoService
            ? QImage(index.data(AbstractVideoListModel::ThumbnailUrlRole).toUrl().toLocalFile())
            : index.data(AbstractVideoListModel::ThumbnailRole).value<QImage>();

    if (!image.isNull()) {
        painter->drawImage(imageRect, image);
    }
    else {
        painter->drawImage(imageRect.left() + 16, imageRect.top() + 6, QImage("/usr/share/icons/hicolor/48x48/hildon/general_video_file.png"));
    }

    painter->drawRect(imageRect);
    painter->restore();
}

QSize PlaybackListDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const {
    Q_UNUSED(index);

    return QSize(option.rect.width(), 70);
}
