#include "navbutton.h"
#include <QPainter>
#include <QtCore/qmath.h>

NavButton::NavButton(const QString &text, const QString &iconSource, QWidget *parent) :
    QWidget(parent),
    m_text(text),
    m_icon(QImage(iconSource)),
    m_pressed(false)
{
    setFixedSize(160, 140);
}

void NavButton::mousePressEvent(QMouseEvent *event) {
    m_pressed = true;
    repaint();
    event->accept();
}

void NavButton::mouseReleaseEvent(QMouseEvent *event) {
    if (rect().contains(event->pos())) {
        m_pressed = false;
        repaint();
        emit clicked();
    }
    else {
        event->ignore();
    }
}

void NavButton::leaveEvent(QEvent *event) {
    m_pressed = false;
    repaint();
    event->accept();
}

void NavButton::paintEvent(QPaintEvent *event) {
    Q_UNUSED(event);

    QPainter painter(this);
    QFont font;

    font.setPixelSize(20);
    painter.setFont(font);

    if (m_pressed) {
        painter.setOpacity(0.5);
    }

    if (!m_icon.isNull()) {
        QRect imageRect = rect();

        imageRect.setTopLeft(QPoint(imageRect.left() + qFloor(m_icon.size().width() / 2), imageRect.top() + 10));
        imageRect.setSize(m_icon.size());

        painter.drawImage(imageRect, m_icon);
    }

    if (!m_text.isEmpty()) {
        QRect textRect = rect();
        textRect.setTop(textRect.top() + 100);

        painter.drawText(textRect, Qt::AlignCenter, m_text);
    }
}
