#ifndef ENUMS_H
#define ENUMS_H

#include <QObject>

class Services : public QObject
{
    Q_OBJECT

    Q_ENUMS(VideoService)

public:
    enum VideoService {
        YouTube = 0,
        Dailymotion,
        Vimeo,
        XHamster,
        XVideos,
        Joggs,
        YouJizz,
        RampantTV,
        NoService
    };

public:
    enum SharingService {
        Facebook = 0,
        Twitter,
        Email,
        Clipboard
    };
};

class Qualities : public QObject
{
    Q_OBJECT

    Q_ENUMS(VideoQuality)

public:
    enum VideoQuality {
        Normal = 0,
        HQ,
        HD,
        SuperHD
    };
};

class Queries : public QObject
{
    Q_OBJECT

    Q_ENUMS(QueryType)

public:
    enum QueryType {
        Videos = 0,
        Playlists,
        Users,
        Groups
    };

    enum QueryOrder {
        Date = 0,
        Relevance,
        Views,
        Rating
    };

    enum TimeFilter {
        None = 0,
        AllTime,
        Today,
        ThisWeek,
        ThisMonth
    };

    enum DurationFilter {
        Any = 0,
        Short,
        Medium,
        Long
    };
};

class ScreenOrientation : public QObject
{
    Q_OBJECT

    Q_ENUMS(Orientation)

public:
    enum Orientation {
        Automatic = 0,
        LockPortrait,
        LockLandscape
    };
};

#endif // ENUMS_H
