#ifndef DAILYMOTIONUSERLISTWINDOW_H
#define DAILYMOTIONUSERLISTWINDOW_H

#include "stackedwindow.h"
#include "dailymotionuserlistmodel.h"
#include "listview.h"
#include <QLabel>

class DailymotionUserListWindow : public StackedWindow
{
    Q_OBJECT

public:
    explicit DailymotionUserListWindow(Session *session, QWidget *parent);
    void setFeed(const QString &feed);
    void search(const QString &query);

private:
    void setLandscapeLayout();
    void setPortraitLayout();
    void showUserChannel(const QString &userId);

private slots:
    void onLoadingChanged();
    void onItemClicked(const QModelIndex &index);

private:
    DailymotionUserListModel *m_model;
    ListView *m_listView;
    QLabel *m_noResultsLabel;
};

#endif // DAILYMOTIONUSERLISTWINDOW_H
