#include "dailymotionuserlistwindow.h"
#include "dailymotionchannelwindow.h"
#include "dailymotionuserlistdelegate.h"

DailymotionUserListWindow::DailymotionUserListWindow(Session *session, QWidget *parent) :
    StackedWindow(session, parent),
    m_model(new DailymotionUserListModel(m_session, this)),
    m_listView(new ListView(this)),
    m_noResultsLabel(new QLabel(QString("<p style='color:#4d4d4d;font-size:40px;'><center><b>%1</b></center></p>").arg(tr("No channels found")), this))
{
    setCentralWidget(m_listView);

    m_listView->setModel(m_model);
    m_listView->setItemDelegate(new DailymotionUserListDelegate(m_listView));
    m_noResultsLabel->hide();

    connect(m_model, SIGNAL(loadingChanged()), this, SLOT(onLoadingChanged()));
    connect(m_listView, SIGNAL(clicked(QModelIndex)), this, SLOT(onItemClicked(QModelIndex)));
    connect(m_listView, SIGNAL(atEnd()), m_model, SLOT(getMoreUsers()));

    onOrientationChanged();
}

void DailymotionUserListWindow::setFeed(const QString &feed) {
    m_model->getUsers(feed);
}

void DailymotionUserListWindow::search(const QString &query) {
    setWindowTitle(tr("Search") + QString(" ('%1')").arg(query));
    m_model->search(query);
}

void DailymotionUserListWindow::setLandscapeLayout() {
    m_noResultsLabel->setFixedSize(800, 400);
}

void DailymotionUserListWindow::setPortraitLayout() {
    m_noResultsLabel->setFixedSize(480, 700);
}

void DailymotionUserListWindow::onLoadingChanged() {
    toggleBusy(m_model->loading());
    m_noResultsLabel->setVisible((!m_model->loading()) && (m_model->rowCount() == 0));
}

void DailymotionUserListWindow::onItemClicked(const QModelIndex &index) {
    if (index.isValid()) {
        showUserChannel(index.data(AbstractUserListModel::IdRole).toString());
    }
}

void DailymotionUserListWindow::showUserChannel(const QString &userId) {
    DailymotionChannelWindow *window = new DailymotionChannelWindow(m_session, userId, this);
    window->show();
}
