#ifndef DAILYMOTIONUSERGROUPLISTTAB_H
#define DAILYMOTIONUSERGROUPLISTTAB_H

#include "abstracttab.h"
#include "listview.h"
#include "dailymotionusergrouplistmodel.h"
#include <QLabel>
#include <QMenu>
#include <QAction>
#include <QGridLayout>

class DailymotionUserGroupListTab : public AbstractTab
{
    Q_OBJECT
public:
    explicit DailymotionUserGroupListTab(Session *session, QWidget *parent = 0);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onGroupsLoaded();
    void onItemClicked(const QModelIndex &index);
    void showGroup(QSharedPointer<GroupItem> group);
    void showContextMenu(const QPoint &pos);
    void leaveGroup();

private:
    Session *m_session;
    ListView *m_listView;
    DailymotionUserGroupListModel *m_model;
    QMenu *m_contextMenu;
    QAction *m_leaveAction;
    QLabel *m_noResultsLabel;
    QGridLayout *m_grid;
};

#endif // DAILYMOTIONUSERGROUPLISTTAB_H
