#ifndef DAILYMOTIONUSERGROUPLISTMODEL_H
#define DAILYMOTIONUSERGROUPLISTMODEL_H

#include "session.h"
#include <QAbstractListModel>

class DailymotionUserGroupListModel : public QAbstractListModel
{
    Q_OBJECT

public:
    enum Roles {

        IdRole = Qt::UserRole+1,
        TitleRole,
        ArtistRole,
        DateRole,
        DescriptionRole
    };

public:
    explicit DailymotionUserGroupListModel(Session *session, QObject *parent = 0);
    ~DailymotionUserGroupListModel() {}
    int rowCount(const QModelIndex &parent = QModelIndex()) const;
    QVariant data(const QModelIndex &index, int role = Qt::DisplayRole) const;
    inline QSharedPointer<GroupItem> get(int row) const { return m_session->dailymotion()->groups()->at(row); }

private slots:
    void onGroupAdded(int row);
    void onGroupRemoved(int row);

private:
    Session *m_session;
};

#endif // DAILYMOTIONUSERGROUPLISTMODEL_H
