#include "dailymotionusergrouplistmodel.h"

DailymotionUserGroupListModel::DailymotionUserGroupListModel(Session *session, QObject *parent) :
    QAbstractListModel(parent),
    m_session(session)
{
    if (!m_session->dailymotion()->groupsLoaded()) {
        m_session->dailymotion()->getGroups();
    }

    connect(m_session->dailymotion(), SIGNAL(groupAddedToCache(int)), this, SLOT(onGroupAdded(int)));
    connect(m_session->dailymotion(), SIGNAL(groupRemovedFromCache(int)), this, SLOT(onGroupRemoved(int)));
}

void DailymotionUserGroupListModel::onGroupAdded(int row) {
    beginInsertRows(QModelIndex(), row, row);
    endInsertRows();
}

void DailymotionUserGroupListModel::onGroupRemoved(int row) {
    beginRemoveRows(QModelIndex(), row, row);
    endRemoveRows();
}

int DailymotionUserGroupListModel::rowCount(const QModelIndex &parent) const {
    Q_UNUSED(parent);

    return m_session->dailymotion()->groups()->size();
}

QVariant DailymotionUserGroupListModel::data(const QModelIndex &index, int role) const {
    switch (role) {
    case IdRole:
        return m_session->dailymotion()->groups()->at(index.row()).data()->id();
    case TitleRole:
        return m_session->dailymotion()->groups()->at(index.row()).data()->title();
    case ArtistRole:
        return m_session->dailymotion()->groups()->at(index.row()).data()->artist();
    case DateRole:
        return m_session->dailymotion()->groups()->at(index.row()).data()->date();
    case DescriptionRole:
        return m_session->dailymotion()->groups()->at(index.row()).data()->description();
    default:
        return QVariant();
    }
}


