#ifndef DAILYMOTIONSUBSCRIPTIONSTAB_H
#define DAILYMOTIONSUBSCRIPTIONSTAB_H

#include "abstracttab.h"
#include "dailymotionsubscriptionlistmodel.h"
#include "listview.h"
#include <QMenu>
#include <QAction>
#include <QLabel>
#include <QGridLayout>

class DailymotionSubscriptionsTab : public AbstractTab
{
    Q_OBJECT
public:
    explicit DailymotionSubscriptionsTab(Session *session, QWidget *parent = 0);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onSubscriptionsLoaded();
    void onItemClicked(const QModelIndex &index);
    void showContextMenu(const QPoint &pos);
    void unsubscribe();
    void showUserChannel(const QString &userId);
    void showSubscriptionVideos();

private:
    Session *m_session;
    DailymotionSubscriptionListModel *m_model;
    ListView *m_listView;
    QMenu *m_contextMenu;
    QAction *m_unsubscribeAction;
    QAction *m_videosAction;
    QLabel *m_noResultsLabel;
    QGridLayout *m_grid;
};

#endif // DAILYMOTIONSUBSCRIPTIONSTAB_H
