#include "dailymotionsubscriptionlistmodel.h"

DailymotionSubscriptionListModel::DailymotionSubscriptionListModel(Session *session, QObject *parent) :
    QAbstractListModel(parent),
    m_session(session),
    m_cache(m_session->newThumbnailCache())
{
    if (!m_session->dailymotion()->subscriptionsLoaded()) {
        m_session->dailymotion()->getSubscriptions();
    }

    connect(m_session->dailymotion(), SIGNAL(subscriptionAddedToCache(int)), this, SLOT(onSubscriptionAdded(int)));
    connect(m_session->dailymotion(), SIGNAL(subscriptionRemovedFromCache(int)), this, SLOT(onSubscriptionRemoved(int)));
    connect(m_cache, SIGNAL(thumbnailReady()), this, SLOT(onThumbnailReady()));
}

DailymotionSubscriptionListModel::~DailymotionSubscriptionListModel() {
    delete m_cache;
}

void DailymotionSubscriptionListModel::onSubscriptionAdded(int row) {
    beginInsertRows(QModelIndex(), row, row);
    endInsertRows();
}

void DailymotionSubscriptionListModel::onSubscriptionRemoved(int row) {
    beginRemoveRows(QModelIndex(), row, row);
    endRemoveRows();
}

int DailymotionSubscriptionListModel::rowCount(const QModelIndex &parent) const {
    Q_UNUSED(parent);

    return m_session->dailymotion()->subscriptions()->size();
}

QVariant DailymotionSubscriptionListModel::data(const QModelIndex &index, int role) const {
    switch (role) {
    case IdRole:
        return m_session->dailymotion()->subscriptions()->at(index.row()).data()->id();
    case SubscriptionIdRole:
        return m_session->dailymotion()->subscriptions()->at(index.row()).data()->subscriptionId();
    case UsernameRole:
        return m_session->dailymotion()->subscriptions()->at(index.row()).data()->username();
    case ChannelNameRole:
        return m_session->dailymotion()->subscriptions()->at(index.row()).data()->channelName();
    case AvatarRole:
        return m_cache->thumbnail(m_session->dailymotion()->subscriptions()->at(index.row()).data()->avatarUrl(), QSize(60, 60));
    case VideoCountRole:
        return m_session->dailymotion()->subscriptions()->at(index.row()).data()->videoCount();
    case SubscriberCountRole:
        return m_session->dailymotion()->subscriptions()->at(index.row()).data()->subscriberCount();
    case SubscriptionRole:
        return m_session->dailymotion()->subscriptions()->at(index.row()).data()->subscription();
    default:
        return QVariant();
    }
}

void DailymotionSubscriptionListModel::onThumbnailReady() {
    emit dataChanged(index(0), index(rowCount() - 1));
}
