#include "dailymotiongrouplistwindow.h"
#include "dailymotionvideolistwindow.h"
#include "dailymotiongrouplistdelegate.h"

DailymotionGroupListWindow::DailymotionGroupListWindow(Session *session, QWidget *parent) :
    StackedWindow(session, parent),
    m_listView(new ListView(this)),
    m_model(new DailymotionGroupListModel(m_session, this)),
    m_noResultsLabel(new QLabel(QString("<p style='color:#4d4d4d;font-size:40px;'><center><b>%1</b></center></p>").arg(tr("No groups found")), this))
{
    setCentralWidget(m_listView);

    m_listView->setModel(m_model);
    m_listView->setItemDelegate(new DailymotionGroupListDelegate(m_listView));
    m_noResultsLabel->hide();

    connect(m_model, SIGNAL(loadingChanged()), this, SLOT(onLoadingChanged()));
    connect(m_listView, SIGNAL(clicked(QModelIndex)), this, SLOT(onItemClicked(QModelIndex)));

    onOrientationChanged();
}

void DailymotionGroupListWindow::setLandscapeLayout() {
    m_noResultsLabel->setFixedSize(800, 400);
}

void DailymotionGroupListWindow::setPortraitLayout() {
    m_noResultsLabel->setFixedSize(480, 700);
}

void DailymotionGroupListWindow::search(const QString &query, Queries::QueryOrder order) {
    setWindowTitle(tr("Search") + QString(" ('%1')").arg(query));
    m_model->search(query, order);
}

void DailymotionGroupListWindow::onLoadingChanged() {
    toggleBusy(m_model->loading());
    m_noResultsLabel->setVisible((!m_model->loading()) && (m_model->rowCount() == 0));
}

void DailymotionGroupListWindow::onItemClicked(const QModelIndex &index) {
    if (index.isValid()) {
        showGroup(m_model->get(index.row()));
    }
}

void DailymotionGroupListWindow::showGroup(QSharedPointer<GroupItem> group) {
    DailymotionVideoListWindow *window = new DailymotionVideoListWindow(m_session, this);
    window->setWindowTitle(group.data()->title());
    window->getGroupVideos(group);
    window->show();
}
