#ifndef DAILYMOTIONGROUPLISTTAB_H
#define DAILYMOTIONGROUPLISTTAB_H

#include "abstracttab.h"
#include "listview.h"
#include "dailymotiongrouplistmodel.h"
#include <QLabel>
#include <QGridLayout>

class DailymotionGroupListTab : public AbstractTab
{
    Q_OBJECT
public:
    explicit DailymotionGroupListTab(Session *session, QWidget *parent = 0);
    void setGroupFeed(const QString &feed);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onLoadingChanged();
    void onItemClicked(const QModelIndex &index);
    void showGroup(QSharedPointer<GroupItem> group);

private:
    Session *m_session;
    ListView *m_listView;
    DailymotionGroupListModel *m_model;
    QLabel *m_noResultsLabel;
    QGridLayout *m_grid;
};

#endif // DAILYMOTIONGROUPLISTTAB_H
