#include "dailymotioncommentlistmodel.h"
#include "feedurls.h"
#include "json.h"
#include <QtNetwork/QNetworkReply>
#include <QtNetwork/QNetworkRequest>

using namespace QtJson;

DailymotionCommentListModel::DailymotionCommentListModel(Session *session, QObject *parent) :
    AbstractCommentListModel(session->newThumbnailCache(), parent),
    m_session(session),
    m_moreResults(true),
    m_error(false),
    m_offset(1)
{
    connect(m_session->dailymotion(), SIGNAL(commentAdded(QSharedPointer<CommentItem>)), this, SLOT(onCommentAdded(QSharedPointer<CommentItem>)));
}

void DailymotionCommentListModel::setVideoId(const QString &id) {
    m_videoId = id;
    setFeed("https://api.dailymotion.com/video/" + videoId() + QString("/comments?limit=30&fields=") + DAILYMOTION_COMMENT_FIELDS);
}

void DailymotionCommentListModel::getComments(const QString &id) {
    if (!id.isEmpty()) {
        setVideoId(id);
    }

    setLoading(true);
    QNetworkReply *reply = m_session->dailymotion()->createReply(feed(), offset());
    connect(reply, SIGNAL(finished()), this, SLOT(addComments()));
}

void DailymotionCommentListModel::addComments() {
    QNetworkReply *reply = qobject_cast<QNetworkReply*>(sender());

    if (!reply) {
        setLoading(false);
        setError(true);
        return;
    }

    int statusCode = reply->attribute(QNetworkRequest::HttpStatusCodeAttribute).toInt();

    if (statusCode == 401) {
        connect(m_session->dailymotion(), SIGNAL(accessTokenRefreshed(QString,QString)), this, SLOT(getComments()));
        connect(m_session->dailymotion(), SIGNAL(refreshError()), this, SLOT(onError()));
        m_session->dailymotion()->refreshAccessToken();
    }
    else {
        QString response(reply->readAll());
        bool ok;
        QVariantMap res = Json::parse(response, ok).toMap();

        if (!ok) {
            setLoading(false);
            setError(true);
        }
        else {
            QVariantList entries = res.value("list").toList();

            for (int i = 0; i < entries.size(); i++) {
                appendComment(QSharedPointer<CommentItem>(new CommentItem(entries.at(i).toMap())));
            }

            setLoading(false);
            setMoreResults(res.value("has_more").toBool());
            setOffset(res.value("page").toInt() + 1);
        }

        disconnect(m_session->dailymotion(), SIGNAL(accessTokenRefreshed(QString,QString)), this, SLOT(getComments()));
        disconnect(m_session->dailymotion(), SIGNAL(refreshError()), this, SLOT(onError()));
    }

    reply->deleteLater();
}

void DailymotionCommentListModel::getMoreComments() {
    if ((moreResults()) && (!loading())) {
        getComments();
    }
}

void DailymotionCommentListModel::onCommentAdded(QSharedPointer<CommentItem> comment) {
    if ((!comment.isNull()) && (comment.data()->videoId() == videoId())) {
        insertComment(0, comment);
    }
}
