#include "dailymotioncategorymodel.h"
#include "feedurls.h"

DailymotionCategoryModel::DailymotionCategoryModel(QObject *parent) :
    SelectionModel(parent)
{
    setTextAlignment(Qt::AlignLeft);

    addItem(tr("Animals"), feedFromValue("animals"));
    addItem(tr("Arts"), feedFromValue("arts"));
    addItem(tr("Auto-Moto"), feedFromValue("auto"));
    addItem(tr("Film & TV"), feedFromValue("shortfilms"));
    addItem(tr("Funny"), feedFromValue("fun"));
    addItem(tr("Gaming"), feedFromValue("videogames"));
    addItem(tr("Gay & Lesbian"), feedFromValue("gaylesbian"));
    addItem(tr("Kids"), feedFromValue("kids"));
    addItem(tr("Life & Style"), feedFromValue("lifestyle"));
    addItem(tr("Most Recent"), feedFromValue("most_recent"));
    addItem(tr("Most Viewed"), feedFromValue("most_viewed"));
    addItem(tr("Music"), feedFromValue("music"));
    addItem(tr("News & Politics"), feedFromValue("news"));
    addItem(tr("People & Family"), feedFromValue("people"));
    addItem(tr("Sexy"), feedFromValue("sexy"));
    addItem(tr("Sports & Extreme"), feedFromValue("sport"));
    addItem(tr("Tech & Science"), feedFromValue("tech"));
    addItem(tr("Travel"), feedFromValue("travel"));
    addItem(tr("Webcam & Vlogs"), feedFromValue("webcam"));
}

QString DailymotionCategoryModel::feedFromValue(const QString &value) {
    QString feed(DAILYMOTION_VIDEOS_BASE_URL);

    if (value == "most_recent") {
        feed.append("?sort=recent&limit=30");
    }
    else if (value == "most_viewed") {
        feed.append("?sort=visited&limit=30");
    }
    else {
        feed.append(QString("?sort=recent&limit=30&channel=%1").arg(value));
    }

    return feed;
}
