#ifndef YOUTUBEVIDEOCOMMENTSTAB_H
#define YOUTUBEVIDEOCOMMENTSTAB_H

#include "abstracttab.h"
#include "session.h"
#include "videoitem.h"
#include "youtubecommentlistmodel.h"
#include "listview.h"
#include <QMenu>
#include <QAction>
#include <QLabel>
#include <QGridLayout>

class YouTubeVideoCommentsTab : public AbstractTab
{
    Q_OBJECT

public:
    explicit YouTubeVideoCommentsTab(Session *session, QSharedPointer<VideoItem> video, QWidget *parent);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onLoadingChanged();
    void showCommentDialog(QSharedPointer<CommentItem> initialComment = QSharedPointer<CommentItem>());
    void showContextMenu(const QPoint &pos);
    void replyToComment();
    void showUserChannel(const QModelIndex &index);
    
private:
    Session *m_session;
    QSharedPointer<VideoItem> m_video;
    YouTubeCommentListModel *m_model;
    ListView *m_listView;
    QMenu *m_contextMenu;
    QAction *m_replyAction;
    QAction *m_commentAction;
    QLabel *m_noResultsLabel;
    QGridLayout *m_grid;
};

#endif // YOUTUBEVIDEOCOMMENTSTAB_H
