#ifndef YOUTUBEPLAYLISTLISTWINDOW_H
#define YOUTUBEPLAYLISTLISTWINDOW_H

#include "stackedwindow.h"
#include "youtubeplaylistlistmodel.h"
#include "listview.h"
#include <QLabel>

class YouTubePlaylistListWindow : public StackedWindow
{
    Q_OBJECT
public:
    explicit YouTubePlaylistListWindow(Session *session, QWidget *parent);
    void setPlaylistFeed(const QString &feed);
    void search(const QString &query, Queries::QueryOrder order);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onLoadingChanged();
    void onItemClicked(const QModelIndex &index);
    void showPlaylist(QSharedPointer<PlaylistItem> playlist);

private:
    ListView *m_listView;
    YouTubePlaylistListModel *m_model;
    QLabel *m_noResultsLabel;
};

#endif // YOUTUBEPLAYLISTLISTWINDOW_H
