#ifndef YOUTUBEAUTHDIALOG_H
#define YOUTUBEAUTHDIALOG_H

#include "abstractdialog.h"
#include "session.h"
#include "webview.h"
#include <QProgressBar>
#include <QGridLayout>

class YouTubeAuthDialog : public AbstractDialog
{
    Q_OBJECT

public:
    explicit YouTubeAuthDialog(Session *session, const QString &accountName, QWidget *parent = 0);

private:
    inline void setLandscapeLayout() { setFixedHeight(340); }
    inline void setPortraitLayout() { setFixedHeight(600); }

private slots:
    void checkTitleForCode(const QString &title);

private:
    Session *m_session;
    QString m_name;
    WebView *m_webView;
    QProgressBar *m_progressBar;
    QGridLayout *m_grid;
};

#endif // YOUTUBEAUTHDIALOG_H
