#include "xtube.h"
#include <QNetworkRequest>
#include <QNetworkReply>
#include <QStringList>
#include <QRegExp>
#include <QtWebKit/QWebPage>
#include <QtWebKit/QWebFrame>
#include <QtWebKit/QWebElementCollection>

XTube::XTube(QObject *parent) :
    QObject(parent),
    m_nam(0)
{    
    m_xhamsterOrders[Queries::Relevance] = "re";
    m_xhamsterOrders[Queries::Date] = "da";
    m_xhamsterOrders[Queries::Views] = "vc";
    m_xhamsterOrders[Queries::Rating] = "rt";

    m_xhamsterTimeFilters[Queries::AllTime] = "Anytime";
    m_xhamsterTimeFilters[Queries::Today] = "last_day";
    m_xhamsterTimeFilters[Queries::ThisWeek] = "last_week";
    m_xhamsterTimeFilters[Queries::ThisMonth] = "last_month";

    m_xhamsterDurationFilters[Queries::Any] = "Any";
    m_xhamsterDurationFilters[Queries::Short] = "0-10";
    m_xhamsterDurationFilters[Queries::Medium] = "10-40";
    m_xhamsterDurationFilters[Queries::Long] = "40+";

    m_xvideosOrders[Queries::Relevance] = "relevance";
    m_xvideosOrders[Queries::Date] = "uploaddate";
    m_xvideosOrders[Queries::Rating] = "rating";

    m_xvideosTimeFilters[Queries::AllTime] = "all";
    m_xvideosTimeFilters[Queries::Today] = "today";
    m_xvideosTimeFilters[Queries::ThisWeek] = "week";
    m_xvideosTimeFilters[Queries::ThisMonth] = "month";

    m_xvideosDurationFilters[Queries::Any] = "allduration";
    m_xvideosDurationFilters[Queries::Short] = "1-3";
    m_xvideosDurationFilters[Queries::Medium] = "3-10";
    m_xvideosDurationFilters[Queries::Long] = "10min_more";
}

void XTube::search(Services::VideoService service, QString query, int offset, Queries::QueryOrder order, Queries::TimeFilter time, Queries::DurationFilter duration) {
    switch (service) {
    case Services::XHamster:
        searchXHamster(query, offset, order, time, duration);
        break;
    case Services::XVideos:
        searchXVideos(query, offset, order, time, duration);
        break;
    case Services::Joggs:
        searchJoggs(query, offset);
        break;
    case Services::YouJizz:
        searchYouJizz(query, offset);
        break;
    case Services::RampantTV:
        searchRampantTV(query, offset);
        break;
    default:
        return;
    }
}

void XTube::searchXHamster(QString query, int offset, Queries::QueryOrder order, Queries::TimeFilter time, Queries::DurationFilter duration) {
    QUrl url("http://www.xhamster.com/search.php");
    url.addQueryItem("q", query.simplified());
    url.addQueryItem("s", m_xhamsterOrders[order]);
    url.addQueryItem("date", m_xhamsterTimeFilters[time]);
    url.addQueryItem("length", m_xhamsterDurationFilters[duration]);
    url.addQueryItem("page", QString::number(offset));
    QNetworkRequest request(url);
    QNetworkReply *reply = networkAccessManager()->get(request);
    connect(reply, SIGNAL(finished()), this, SLOT(parseXHamsterPage()));
}

void XTube::searchXVideos(QString query, int offset, Queries::QueryOrder order, Queries::TimeFilter time, Queries::DurationFilter duration) {
    QUrl url("http://www.xvideos.com/");
    url.addQueryItem("k", query.simplified());
    url.addQueryItem("sort", m_xvideosOrders[order]);
    url.addQueryItem("datef", m_xvideosTimeFilters[time]);
    url.addQueryItem("durf", m_xvideosDurationFilters[duration]);

    if (offset > 1) {
        url.addQueryItem("p", QString::number(offset));
    }

    QNetworkRequest request(url);
    QNetworkReply *reply = networkAccessManager()->get(request);
    connect(reply, SIGNAL(finished()), this, SLOT(parseXVideosPage()));
}

void XTube::searchJoggs(QString query, int offset) {
    QUrl url(QString("http://joggs.com/search/%1/page%2.html").arg(query.simplified(), QString::number(offset)));
    QNetworkRequest request(url);
    QNetworkReply *reply = networkAccessManager()->get(request);
    connect(reply, SIGNAL(finished()), this, SLOT(parseJoggsPage()));
}

void XTube::searchYouJizz(QString query, int offset) {
    QUrl url(QString("http://www.youjizz.com/search/%1-%2.html").arg(query.simplified(), QString::number(offset)));
    QNetworkRequest request(url);
    QNetworkReply *reply = networkAccessManager()->get(request);
    connect(reply, SIGNAL(finished()), this, SLOT(parseYouJizzPage()));
}

void XTube::searchRampantTV(QString query, int offset) {
    QUrl url(QString("http://tube.rampant.tv/search/%1/page%2.html").arg(query.simplified(), QString::number(offset)));
    QNetworkRequest request(url);
    QNetworkReply *reply = networkAccessManager()->get(request);
    connect(reply, SIGNAL(finished()), this, SLOT(parseRampantTVPage()));
}

void XTube::parseXHamsterPage() {
    QNetworkReply *reply = qobject_cast<QNetworkReply*>(sender());

    if (!reply) {
        emit error(tr("Network error"));
        return;
    }

    QList< QSharedPointer<VideoItem> > videos;

    QString response(reply->readAll());
    response.remove(QRegExp("<head>.*</head>"));
    QWebPage page;
    page.mainFrame()->setHtml(response);
    QWebElement doc = page.mainFrame()->documentElement();
    QWebElementCollection elements = doc.findFirst("div.moduleFeatured").findFirst("table").findAll("td");

    for (int i = 0; i < elements.count(); i++) {
        QWebElement el = elements.at(i);
        QString link = el.findFirst("a").attribute("href");

        if (!link.isEmpty()) {
            QWebElement imageElement = el.findFirst("img");
            QString image = imageElement.attribute("src");
            QString title = imageElement.attribute("alt");
            QString info = el.findFirst("div.moduleFeaturedDetails").toPlainText();

            QString durationString = info.section("Runtime: ", 1, 1).left(5);
            int mins = durationString.left(2).toInt();
            int secs = durationString.right(2).toInt();
            int duration = mins * 60 + secs;
            int views = info.section(' ', -1).remove(',').toInt();

            QSharedPointer<VideoItem> video(new VideoItem);
            video.data()->setId("http://www.xhamster.com" + link);
            video.data()->setVideoId(video.data()->id());
            video.data()->setUrl(QUrl(video.data()->id()));
            video.data()->setTitle(title);
            video.data()->setThumbnailUrl(QUrl(image));
            video.data()->setDuration(duration);
            video.data()->setViewCount(views);
            video.data()->setService(Services::XHamster);
            videos.append(video);
        }
    }

    emit gotVideos(videos);

    reply->deleteLater();
}

void XTube::parseXVideosPage() {
    QNetworkReply *reply = qobject_cast<QNetworkReply*>(sender());

    if (!reply) {
        emit error(tr("Network error"));
        return;
    }

    QList< QSharedPointer<VideoItem> > videos;

    QString response(reply->readAll());
    response.remove(QRegExp("<head>.*</head>"));
    QWebPage page;
    page.mainFrame()->setHtml(response);
    QWebElement doc = page.mainFrame()->documentElement();
    QWebElementCollection elements = doc.findAll("div.thumbInside");

    for (int i = 0; i < elements.count(); i++) {
        QWebElement el = elements.at(i);
        QWebElement linkElement = el.findFirst("a");
        QString link = "http://www.xvideos.com/" + linkElement.attribute("href");
        QString image = linkElement.findFirst("img").attribute("src");
        QString title = el.findFirst("p").firstChild().toPlainText();
        QString info = el.findFirst("span.duration").toPlainText();
        QString durationString = info.section('(', 1, 1).section(')', 0, 0);
        int mins = durationString.section(" min", 0, 0).toInt();
        int secs = durationString.section(" min", 1, 1).section(" sec", 0, 0).toInt();
        int duration = mins * 60 + secs;

        QSharedPointer<VideoItem> video(new VideoItem);
        video.data()->setId(link);
        video.data()->setVideoId(link);
        video.data()->setUrl(QUrl(link));
        video.data()->setTitle(title);
        video.data()->setThumbnailUrl(QUrl(image));
        video.data()->setDuration(duration);
        video.data()->setViewCount(0);
        video.data()->setService(Services::XVideos);
        videos.append(video);
    }

    emit gotVideos(videos);

    reply->deleteLater();
}

void XTube::parseJoggsPage() {
    QNetworkReply *reply = qobject_cast<QNetworkReply*>(sender());

    if (!reply) {
        emit error(tr("Network error"));
        return;
    }

    QList< QSharedPointer<VideoItem> > videos;

    QString response(reply->readAll());
    response.remove(QRegExp("<head>.*</head>"));
    QWebPage page;
    page.mainFrame()->setHtml(response);
    QWebElement doc = page.mainFrame()->documentElement();
    QWebElementCollection elements = doc.findAll("div.koncontent");

    for (int i = 0; i < elements.count(); i++) {
        QWebElement el = elements.at(i);
        QWebElement linkElement = el.findFirst("h3").firstChild();
        QString link = linkElement.attribute("href");
        QWebElementCollection imageElements = el.findAll("img");
        QString image;
        QString title;

        if (imageElements.count() > 0) {
            QWebElement imageElement = imageElements.last();
            image = imageElement.attribute("src");
            title = imageElement.attribute("alt");
        }

        QString info = el.findFirst("div.ba").toPlainText().simplified();
        QString durationString = info.section("Runtime: ", 1, 1).left(5);
        int mins = durationString.left(2).toInt();
        int secs = durationString.right(2).toInt();
        int duration = mins * 60 + secs;
        int views = info.section(' ', -1).toInt();

        QSharedPointer<VideoItem> video(new VideoItem);
        video.data()->setId(link);
        video.data()->setVideoId(link);
        video.data()->setUrl(QUrl(link));
        video.data()->setTitle(title);
        video.data()->setThumbnailUrl(QUrl(image));
        video.data()->setDuration(duration);
        video.data()->setViewCount(views);
        video.data()->setService(Services::Joggs);
        videos.append(video);
    }

    emit gotVideos(videos);

    reply->deleteLater();
}

void XTube::parseYouJizzPage() {
    QNetworkReply *reply = qobject_cast<QNetworkReply*>(sender());

    if (!reply) {
        emit error(tr("Network error"));
        return;
    }

    QList< QSharedPointer<VideoItem> > videos;

    QString response(reply->readAll());
    response.remove(QRegExp("<head>.*(?=<table)"));
    QWebPage page;
    page.mainFrame()->setHtml(response);
    QWebElement doc = page.mainFrame()->documentElement();
    QWebElementCollection elements = doc.findAll("a.frame");

    for (int i = 0; i < elements.count(); i++) {
        QWebElement el = elements.at(i);
        QString link = "http://www.youjizz.com" + el.attribute("href");
        QString image = el.nextSibling().attribute("data-original");
        QWebElement titleElement = el.parent().nextSibling();
        QString title = titleElement.toPlainText();
        QString durationString = titleElement.nextSibling().findFirst("span.thumbtime").firstChild().toPlainText();
        int mins = durationString.left(2).trimmed().toInt();
        int secs = durationString.right(2).toInt();
        int duration = mins * 60 + secs;
        int views = titleElement.nextSibling().findFirst("span.thumbviews").firstChild().toPlainText().toInt();

        QSharedPointer<VideoItem> video(new VideoItem);
        video.data()->setId(link);
        video.data()->setVideoId(link);
        video.data()->setUrl(QUrl(link));
        video.data()->setTitle(title);
        video.data()->setThumbnailUrl(QUrl(image));
        video.data()->setDuration(duration);
        video.data()->setViewCount(views);
        video.data()->setService(Services::YouJizz);
        videos.append(video);
    }

    emit gotVideos(videos);

    reply->deleteLater();
}

void XTube::parseRampantTVPage() {
    QNetworkReply *reply = qobject_cast<QNetworkReply*>(sender());

    if (!reply) {
        emit error(tr("Network error"));
        return;
    }

    QList< QSharedPointer<VideoItem> > videos;

    QString response(reply->readAll());
    response.remove(QRegExp("<head>.*(?=<div id=\"main\">)"));
    QWebPage page;
    page.mainFrame()->setHtml(response);
    QWebElement doc = page.mainFrame()->documentElement();
    QWebElementCollection elements = doc.findAll("div.content");

    for (int i = 0; i < elements.count(); i++) {
        QWebElement el = elements.at(i);
        QWebElementCollection linkElements = el.findAll("a");

        if (linkElements.count() > 1) {
            QWebElement linkElement = linkElements.at(1);
            QString link = linkElement.attribute("href");
            QWebElement imageElement = linkElement.findFirst("img");
            QString image = imageElement.attribute("src");
            QString title = imageElement.attribute("alt");
            QString durationString = el.findFirst("div.time").toPlainText();
            int mins = durationString.left(2).trimmed().toInt();
            int secs = durationString.right(2).toInt();
            int duration = mins * 60 + secs;
            int views = el.findFirst("div.views").toPlainText().section(' ', 0, 0).toInt();

            QSharedPointer<VideoItem> video(new VideoItem);
//            video.data()->setId(link);
//            video.data()->setVideoId(link);
//            video.data()->setUrl(QUrl(link));
            video.data()->setId(image);
            video.data()->setVideoId(image);
            video.data()->setUrl(QUrl(image));
            video.data()->setTitle(title);
            video.data()->setThumbnailUrl(QUrl(image));
            video.data()->setDuration(duration);
            video.data()->setViewCount(views);
            video.data()->setService(Services::RampantTV);
            videos.append(video);
        }
    }

    emit gotVideos(videos);

    reply->deleteLater();
}
