#include "vimeovideolistmodel.h"

VimeoVideoListModel::VimeoVideoListModel(Session *session, QObject *parent) :
    AbstractVideoListModel(session->newThumbnailCache(), parent),
    m_session(session)
{
    connect(m_session->vimeo(), SIGNAL(gotVideos(QList< QSharedPointer<VideoItem> >)), this, SLOT(addVideos(QList< QSharedPointer<VideoItem> >)));
    connect(m_session->vimeo(), SIGNAL(error(QString)), this, SLOT(onError()));
    connect(m_cache, SIGNAL(thumbnailReady()), this, SLOT(onThumbnailReady()));
}

void VimeoVideoListModel::search(const QString &aquery, Queries::QueryOrder anorder) {
    setLoading(true);

    if (!aquery.isEmpty()) {
        setQuery(aquery);
        setOffset(1);
        setOrder(anorder);
    }

    m_session->vimeo()->search(query(), offset(), order());
}

void VimeoVideoListModel::addVideos(QList< QSharedPointer<VideoItem> > videos) {
    if (videos.isEmpty()) {
        setMoreResults(false);
        setOffset(1);
    }
    else {
        setMoreResults(true);
        setOffset(offset() + 1);
    }

    while (!videos.isEmpty()) {
        appendVideo(videos.takeFirst());
    }

    setLoading(false);
}

void VimeoVideoListModel::getMoreVideos() {
    if ((moreResults()) && (!loading())) {
        search();
    }
}
