#ifndef VIMEOVIDEOINFOWINDOW_H
#define VIMEOVIDEOINFOWINDOW_H

#include "stackedwindow.h"
#include "videoitem.h"
#include "thumbnaillabel.h"
#include <QAction>
#include <QLabel>
#include <QScrollArea>
#include <QGridLayout>

class VimeoVideoInfoWindow : public StackedWindow
{
    Q_OBJECT

public:
    explicit VimeoVideoInfoWindow(Session *session, QSharedPointer<VideoItem> video, QWidget *parent);

private:
    void setLandscapeLayout();
    void setPortraitLayout();
    QString tagsToString(QStringList tags);

private slots:
    void setVideoInfo();
    void addVideoToPlaybackQueue();
    void addVideoDownload();
    void addAudioDownload();
    void playVideo();
    void setThumbnails();
    void showShareDialog();
    void shareVideo(Services::SharingService service);
    void showFacebookDialog();
    void showTwitterDialog();
    void search(const QString &query);

private:
    QSharedPointer<VideoItem> m_video;
    QAction *m_queueAction;
    QAction *m_videoDownloadAction;
    QAction *m_audioDownloadAction;
    QAction *m_shareAction;
    ThumbnailLabel *m_thumbnail;
    ThumbnailLabel *m_avatar;
    QLabel *m_titleLabel;
    QLabel *m_dateLabel;
    QLabel *m_ratingLabel;
    QLabel *m_viewsLabel;
    QLabel *m_descriptionLabel;
    QLabel *m_tagsLabel;
    QScrollArea *m_scrollArea;
    QGridLayout *m_grid;
};

#endif // VIMEOVIDEOINFOWINDOW_H
