#ifndef USERITEM_H
#define USERITEM_H

#include <QObject>
#include <QUrl>
#include <QtXml/QDomElement>
#include <QVariantMap>

class UserItem : public QObject
{
    Q_OBJECT

public:
    explicit UserItem(QObject *parent = 0): QObject(parent) {}
    explicit UserItem(const QVariantMap &user, bool subscribed = false, QObject *parent = 0);
    explicit UserItem(const QDomNode &user, bool subscription = false, bool subscribed = false, QObject *parent = 0);
    ~UserItem() {}
    inline QString id() const { return m_id; }
    inline void setId(const QString &id) { m_id = id; }
    inline QString username() const { return m_username; }
    inline void setUsername(const QString &user) { m_username = user; }
    inline QString channelName() const { return m_channelName; }
    inline void setChannelName(const QString &name) { m_channelName = name; }
    inline int age() const { return m_age; }
    inline void setAge(int age) { m_age = age; }
    inline QString gender() const { return m_gender; }
    inline void setGender(const QString &gender) { m_gender = gender; }
    inline QString description() const { return m_description; }
    inline void setDescription(const QString &description) { m_description = description; }
    inline QUrl avatarUrl() const { return m_avatarUrl; }
    inline void setAvatarUrl(const QUrl &url) { m_avatarUrl = url; }
    inline QString fullname() const { return m_fullname; }
    inline void setFullname(const QString &name) { m_fullname = name; }
    inline QString location() const { return m_location; }
    inline void setLocation(const QString &location) { m_location = location; }
    inline int videoCount() const { return m_videoCount; }
    inline void setVideoCount(int count) { m_videoCount = count; emit videoCountChanged(); }
    inline int viewCount() const { return m_viewCount; }
    inline void setViewCount(int count) { m_viewCount = count; }
    inline int subscriberCount() const { return m_subscriberCount; }
    inline void setSubscriberCount(int count) { m_subscriberCount = count; emit subscriberCountChanged(); }
    inline QUrl websiteUrl() const { return m_websiteUrl; }
    inline void setWebsiteUrl(const QUrl &url) { m_websiteUrl = url; }
    inline bool subscription() const { return m_subscription; }
    inline void setSubscription(bool subscription) { m_subscription = subscription; }
    inline bool subscribed() const { return m_subscribed; }
    inline void setSubscribed(bool subscribed) { m_subscribed = subscribed; emit subscribedChanged(); }
    inline QString subscriptionId() const { return m_subscriptionId; }
    inline void setSubscriptionId(const QString &id) { m_subscriptionId = id; emit subscriptionIdChanged(); }
    inline bool accountLinked() const { return m_accountLinked; }

public slots:
    inline void setAccountLinked(bool linked) { m_accountLinked = linked; }

signals:
    void videoCountChanged();
    void subscriberCountChanged();
    void subscribedChanged();
    void subscriptionIdChanged();

private:
    QString m_id;
    QString m_username;
    QString m_channelName;
    QString m_description;
    QUrl m_avatarUrl;
    QString m_fullname;
    int m_age;
    QString m_gender;
    QString m_location;
    int m_videoCount;
    int m_viewCount;
    int m_subscriberCount;
    QUrl m_websiteUrl;
    bool m_subscription;
    bool m_subscribed;
    QString m_subscriptionId;
    bool m_accountLinked;
};

#endif // USERITEM_H
