#include "textlistdelegate.h"
#include <QStaticText>

TextListDelegate::TextListDelegate(Qt::Alignment alignment, QListView *parent) :
    QStyledItemDelegate(parent),
    m_view(parent),
    m_alignment(alignment)
{
}

void TextListDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const {

    if ((option.state) & (QStyle::State_Selected)) {
        painter->drawImage(option.rect, QImage("/etc/hildon/theme/images/TouchListBackgroundPressed.png"));
    }
    else {
        painter->drawImage(option.rect, QImage("/etc/hildon/theme/images/TouchListBackgroundNormal.png"));
    }

    QRect rect = option.rect;
    rect.setLeft(rect.left() + 10);
    rect.setRight(rect.right() - 10);

    QStaticText text(index.data().toString());
    text.setTextOption(QTextOption(m_alignment));
    text.setTextWidth(rect.width());

    painter->drawStaticText(rect.left(), rect.center().y() - text.size().height() / 2, text);
}

QSize TextListDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const {
    Q_UNUSED(option);
    Q_UNUSED(index);

    return QSize(m_view->width(), 80);
}
