#include "selectionmodels.h"
#include <QFileInfo>

SelectionModel::SelectionModel(QObject *parent) :
    QStandardItemModel(parent),
    m_textAlignment(Qt::AlignCenter)
{
}

QString SelectionModel::name(int row) const {
    return data(index(row, 0), Qt::DisplayRole).toString();
}

QVariant SelectionModel::value(int row) const {
    return data(index(row, 0), Qt::UserRole + 1);
}

void SelectionModel::addItem(const QString &name, const QVariant &value) {
    QStandardItem *item = new QStandardItem(name);
    item->setData(value);
    item->setTextAlignment(textAlignment());
    item->setEditable(false);
    appendRow(item);
}

SearchOrderModel::SearchOrderModel(QObject *parent) :
    SelectionModel(parent)
{
    addItem(tr("Date"), Queries::Date);
    addItem(tr("Relevance"), Queries::Relevance);
    addItem(tr("Views"), Queries::Views);
    addItem(tr("Rating"), Queries::Rating);
}

SearchTypeModel::SearchTypeModel(QObject *parent) :
    SelectionModel(parent)
{
    addItem(tr("Videos"), Queries::Videos);
    addItem(tr("Playlists"), Queries::Playlists);
    addItem(tr("Channels"), Queries::Users);
}

void SearchTypeModel::showGroups(bool show) {
    if (show) {
        addItem(tr("Groups"), Queries::Groups);
    }
    else if (rowCount() > 3) {
        removeRows(3, 1);
    }
}

SearchDurationModel::SearchDurationModel(QObject *parent) :
    SelectionModel(parent)
{
    addItem(tr("Any duration"), Queries::Any);
    addItem(tr("Short"), Queries::Short);
    addItem(tr("Medium"), Queries::Medium);
    addItem(tr("Long"), Queries::Long);
}

SearchTimeModel::SearchTimeModel(QObject *parent) :
    SelectionModel(parent)
{
    addItem(tr("All time"), Queries::AllTime);
    addItem(tr("Today"), Queries::Today);
    addItem(tr("This week"), Queries::ThisWeek);
    addItem(tr("This month"), Queries::ThisMonth);
}

VideoServiceModel::VideoServiceModel(QObject *parent) :
    SelectionModel(parent)
{
    addItem("YouTube", Services::YouTube);
    addItem("Dailymotion", Services::Dailymotion);
}

void VideoServiceModel::showExtras(bool show) {
    if (show) {
        addItem("Vimeo", Services::Vimeo);
    }
    else if (rowCount() > 2) {
        removeRows(2, 1);
    }
}

void VideoServiceModel::showXTube(bool show) {
    if (show) {
        addItem("XHamster", Services::XHamster);
        addItem("XVideos", Services::XVideos);
        addItem("Joggs", Services::Joggs);
        addItem("YouJizz", Services::YouJizz);
        addItem("Rampant TV", Services::RampantTV);
    }
    else if (rowCount() > 2) {
        removeRows(2, 5);
    }
}

MediaPlayerModel::MediaPlayerModel(QObject *parent) :
    SelectionModel(parent)
{
    addItem(tr("Custom command"), "other");

    QFileInfo info("/usr/bin/kmplayer");

    if (info.exists()) {
        addItem("KMPlayer", "kmplayer");
    }
    else {
        info.setFile("/opt/kmplayer/bin/kmplayer");

        if (info.exists()) {
            addItem("KMPlayer", "kmplayer");
        }
    }

    addItem(tr("Media Player"), "mediaplayer");

    info.setFile("/usr/bin/mplayer");

    if (info.exists()) {
        addItem("MPlayer", "mplayer");
    }
}

ScreenOrientationModel::ScreenOrientationModel(QObject *parent) :
    SelectionModel(parent)
{
    addItem(tr("Automatic"), ScreenOrientation::Automatic);
    addItem(tr("Portrait"), ScreenOrientation::LockPortrait);
    addItem(tr("Landscape"), ScreenOrientation::LockLandscape);
}

TransferPriorityModel::TransferPriorityModel(QObject *parent) :
    SelectionModel(parent)
{
    addItem(tr("High"), TransferItem::HighPriority);
    addItem(tr("Normal"), TransferItem::NormalPriority);
    addItem(tr("Low"), TransferItem::LowPriority);
}

YouTubePermissionModel::YouTubePermissionModel(QObject *parent) :
    SelectionModel(parent)
{
    addItem(tr("Yes"), "allowed");
    addItem(tr("No"), "denied");
    addItem(tr("Moderate"), "moderated");
}

YouTubeUploadCategoryModel::YouTubeUploadCategoryModel(QObject *parent) :
    SelectionModel(parent)
{
    addItem(tr("Cars & Vehicles"), "Autos");
    addItem(tr("Comedy"), "Comedy");
    addItem(tr("Education"), "Education");
    addItem(tr("Entertainment"), "Entertainment");
    addItem(tr("Film"), "Film");
    addItem(tr("Gaming"), "Games");
    addItem(tr("Music"), "Music");
    addItem(tr("News & Politics"), "News");
    addItem(tr("Non-profits & Activism"), "Nonprofit");
    addItem(tr("People"), "People");
    addItem(tr("Pets & Animals"), "Animals");
    addItem(tr("Science & Technology"), "Tech");
    addItem(tr("Sport"), "Sports");
    addItem(tr("Style"), "Howto");
    addItem(tr("Travel & Events"), "Travel");
}

DailymotionUploadCategoryModel::DailymotionUploadCategoryModel(QObject *parent) :
    SelectionModel(parent)
{
    addItem(tr("Animals"), "animals");
    addItem(tr("Arts"), "arts");
    addItem(tr("Auto-Moto"), "auto");
    addItem(tr("College"), "schools");
    addItem(tr("Film & TV"), "shortfilms");
    addItem(tr("Funny"), "fun");
    addItem(tr("Gaming"), "videogames");
    addItem(tr("Gay & Lesbian"), "gaylesbian");
    addItem(tr("Kids"), "kids");
    addItem(tr("Life & Style"), "lifestyle");
    addItem(tr("Music"), "music");
    addItem(tr("News & Politics"), "news");
    addItem(tr("People & Family"), "people");
    addItem(tr("Sexy"), "sexy");
    addItem(tr("Sports & Extreme"), "sport");
    addItem(tr("Tech & Science"), "tech");
    addItem(tr("Travel"), "travel");
    addItem(tr("Webcam & Vlogs"), "webcam");
}

SharingModel::SharingModel(QObject *parent) :
    SelectionModel(parent)
{
    addItem(tr("facebook"), Services::Facebook);
    addItem(tr("twitter"), Services::Twitter);
    addItem(tr("Email"), Services::Email);
    addItem(tr("Copy to clipboard"), Services::Clipboard);
}

LanguageModel::LanguageModel(QObject *parent) :
    SelectionModel(parent)
{
    addItem(tr("All languages"), "");
    addItem(tr("Afar"), "aa");
    addItem(tr("Abkhazian"), "ab");
    addItem(tr("Afrikaans"), "af");
    addItem(tr("Akan"), "af");
    addItem(tr("Albanian"), "sq");
    addItem(tr("Amharic"), "am");
    addItem(tr("Arabic"), "ar");
    addItem(tr("Aragonese"), "an");
    addItem(tr("Armenian"), "hy");
    addItem(tr("Assamese"), "as");
    addItem(tr("Avaric"), "av");
    addItem(tr("Avestan"), "ae");
    addItem(tr("Aymara"), "ay");
    addItem(tr("Azerbaijani"), "az");
    addItem(tr("Bashkir"), "ba");
    addItem(tr("Bambara"), "bm");
    addItem(tr("Basque"), "eu");
    addItem(tr("Belarusian"), "be");
    addItem(tr("Bengali"), "bn");
    addItem(tr("Bihari languages"), "bh");
    addItem(tr("Bislama"), "bi");
    addItem(tr("Bosnian"), "bs");
    addItem(tr("Breton"), "br");
    addItem(tr("Bulgarian"), "bg");
    addItem(tr("Burmese"), "my");
    addItem(tr("Catalan"), "ca");
    addItem(tr("Central Khmer"), "km");
    addItem(tr("Chamorro"), "ch");
    addItem(tr("Chechen"), "ce");
    addItem(tr("Chichewa"), "ny");
    addItem(tr("Chinese"), "zh");
    addItem(tr("Church Slavic"), "cu");
    addItem(tr("Chuvash"), "cv");
    addItem(tr("Cornish"), "kw");
    addItem(tr("Corsican"), "co");
    addItem(tr("Cree"), "cr");
    addItem(tr("Croatian"), "hr");
    addItem(tr("Czech"), "cs");
    addItem(tr("Danish"), "da");
    addItem(tr("Divehi"), "dv");
    addItem(tr("Dutch"), "nl");
    addItem(tr("Dzongkha"), "dz");
    addItem(tr("English"), "en");
    addItem(tr("Esperanto"), "eo");
    addItem(tr("Estonian"), "et");
    addItem(tr("Ewe"), "ee");
    addItem(tr("Faroese"), "fo");
    addItem(tr("Fijian"), "fj");
    addItem(tr("Finnish"), "fi");
    addItem(tr("French"), "fr");
    addItem(tr("Fulah"), "ff");
    addItem(tr("Gaelic"), "gd");
    addItem(tr("Galician"), "gl");
    addItem(tr("Ganda"), "lg");
    addItem(tr("Georgian"), "ka");
    addItem(tr("German"), "de");
    addItem(tr("Greek"), "el");
    addItem(tr("Guarani"), "gn");
    addItem(tr("Gujarati"), "gu");
    addItem(tr("Haitian"), "ht");
    addItem(tr("Hausa"), "ha");
    addItem(tr("Hebrew"), "he");
    addItem(tr("Herero"), "hz");
    addItem(tr("Hindi"), "hi");
    addItem(tr("Hiri Motu"), "ho");
    addItem(tr("Hungarian"), "hu");
    addItem(tr("Icelandic"), "is");
    addItem(tr("Ido"), "io");
    addItem(tr("Igbo"), "ig");
    addItem(tr("Indonesian"), "id");
    addItem(tr("Inuktitut"), "iu");
    addItem(tr("Interlingua"), "ia");
    addItem(tr("Interlingue"), "ie");
    addItem(tr("Inupiaq"), "ik");
    addItem(tr("Irish"), "ga");
    addItem(tr("Italian"), "it");
    addItem(tr("Japanese"), "ja");
    addItem(tr("Javanese"), "jv");
    addItem(tr("Kalaallisut"), "kl");
    addItem(tr("Kannada"), "kn");
    addItem(tr("Kanuri"), "kr");
    addItem(tr("Kashmiri"), "ks");
    addItem(tr("Kazakh"), "kk");
    addItem(tr("Kikuyu"), "ki");
    addItem(tr("Kinyarwanda"), "rw");
    addItem(tr("Kirghiz"), "ky");
    addItem(tr("Komi"), "kv");
    addItem(tr("Kongo"), "kg");
    addItem(tr("Korean"), "ko");
    addItem(tr("Kuanyama"), "kj");
    addItem(tr("Kurdish"), "ku");
    addItem(tr("Lao"), "lo");
    addItem(tr("Latin"), "la");
    addItem(tr("Latvian"), "lv");
    addItem(tr("Limburgan"), "li");
    addItem(tr("Lingala"), "ln");
    addItem(tr("Lithuanian"), "lt");
    addItem(tr("Luxembourgish"), "lb");
    addItem(tr("Luba-Katanga"), "lu");
    addItem(tr("Macedonian"), "mk");
    addItem(tr("Malagasy"), "mg");
    addItem(tr("Malay"), "ms");
    addItem(tr("Malayalam"), "ml");
    addItem(tr("Maltese"), "mt");
    addItem(tr("Manx"), "gv");
    addItem(tr("Maori"), "mi");
    addItem(tr("Marathi"), "mr");
    addItem(tr("Marshallese"), "mh");
    addItem(tr("Marxian"), "mx");
    addItem(tr("Mongolian"), "mn");
    addItem(tr("Nauru"), "na");
    addItem(tr("Navajo"), "nv");
    addItem(tr("Ndebele, North"), "nd");
    addItem(tr("Ndebele, South"), "nr");
    addItem(tr("Ndonga"), "ng");
    addItem(tr("Nepali"), "ne");
    addItem(tr("Northern Sami"), "se");
    addItem(tr("Norwegian"), "no");
    addItem(tr("Norwegian Bokmål"), "nb");
    addItem(tr("Norwegian Nynorsk"), "nn");
    addItem(tr("Occitan"), "oc");
    addItem(tr("Ojibwa"), "oj");
    addItem(tr("Oriya"), "or");
    addItem(tr("Oromo"), "om");
    addItem(tr("Ossetian"), "os");
    addItem(tr("Pali"), "pi");
    addItem(tr("Persian"), "fa");
    addItem(tr("Polish"), "pl");
    addItem(tr("Portuguese"), "pt");
    addItem(tr("Punjabi"), "pa");
    addItem(tr("Pushto"), "ps");
    addItem(tr("Quechua"), "qu");
    addItem(tr("Romansh"), "rm");
    addItem(tr("Romanian"), "ro");
    addItem(tr("Rundi"), "rn");
    addItem(tr("Russian"), "ru");
    addItem(tr("Samoan"), "sm");
    addItem(tr("Sango"), "sg");
    addItem(tr("Sanskrit"), "sa");
    addItem(tr("Sardinian"), "sc");
    addItem(tr("Serbian"), "sr");
    addItem(tr("Shona"), "sn");
    addItem(tr("Sindhi"), "sd");
    addItem(tr("Sinhala"), "si");
    addItem(tr("Sichuan Yi"), "ii");
    addItem(tr("Slovak"), "sk");
    addItem(tr("Slovenian"), "sl");
    addItem(tr("Somali"), "so");
    addItem(tr("Sotho, Southern"), "st");
    addItem(tr("Spanish"), "es");
    addItem(tr("Sundanese"), "su");
    addItem(tr("Swahili"), "sw");
    addItem(tr("Swati"), "ss");
    addItem(tr("Swedish"), "sv");
    addItem(tr("Tagalog"), "tl");
    addItem(tr("Tahitian"), "ty");
    addItem(tr("Tajik"), "tg");
    addItem(tr("Tamil"), "ta");
    addItem(tr("Tatar"), "tt");
    addItem(tr("Telugu"), "te");
    addItem(tr("Thai"), "th");
    addItem(tr("Tibetan"), "bo");
    addItem(tr("Tigrinya"), "ti");
    addItem(tr("Tonga"), "to");
    addItem(tr("Tsonga"), "ts");
    addItem(tr("Tswana"), "tn");
    addItem(tr("Turkish"), "tr");
    addItem(tr("Turkmen"), "tk");
    addItem(tr("Twi"), "tw");
    addItem(tr("Uighur"), "ug");
    addItem(tr("Ukrainian"), "uk");
    addItem(tr("Urdu"), "ur");
    addItem(tr("Uzbek"), "uz");
    addItem(tr("Venda"), "ve");
    addItem(tr("Vietnamese"), "vi");
    addItem(tr("Volapük"), "vo");
    addItem(tr("Walloon"), "wa");
    addItem(tr("Welsh"), "cy");
    addItem(tr("Western Frisian"), "fy");
    addItem(tr("Wolof"), "wo");
    addItem(tr("Xhosa"), "xh");
    addItem(tr("Yiddish"), "yi");
    addItem(tr("Yoruba"), "yo");
    addItem(tr("Zhuang"), "za");
    addItem(tr("Zulu"), "zu");
}
