#ifndef OAUTH_H
#define OAUTH_H

#include <QByteArray>
#include <QString>
#include <QMap>
#include <QUrl>

namespace QtOAuth {

class OAuth {

public:
    static QByteArray createOAuthHeader(const QString &method, const QString &url, QMap<QString, QString> params);

private:
    static QString getTimeStamp();
    static QString getNonce();
    static QByteArray createSignature(QByteArray key, QByteArray baseString);
};

}

#endif // OAUTH_H
