#ifndef NAVBUTTON_H
#define NAVBUTTON_H

#include <QWidget>
#include <QMouseEvent>
#include <QPaintEvent>

class NavButton : public QWidget
{
    Q_OBJECT
public:
    explicit NavButton(const QString &text, const QString &iconSource, QWidget *parent = 0);
    void mousePressEvent(QMouseEvent *event);
    void mouseReleaseEvent(QMouseEvent *event);
    void leaveEvent(QEvent *event);
    void paintEvent(QPaintEvent *event);

    
signals:
    void clicked();
    
private:
    QString m_text;
    QImage m_icon;
    bool m_pressed;
};

#endif // NAVBUTTON_H
