#include "mediaplayerselector.h"

MediaPlayerSelector::MediaPlayerSelector(const QString &text, QWidget *parent) :
    QMaemo5ValueButton(text, parent),
    m_model(new MediaPlayerModel(this)),
    m_selector(new QMaemo5ListPickSelector(this))
{
    m_selector->setModel(m_model);
    m_selector->setModelColumn(0);
    setPickSelector(m_selector);
    connect(m_selector, SIGNAL(selected(QString)), this, SLOT(onSelected()));
}

void MediaPlayerSelector::setValue(const QString &value) {
    bool found = false;
    int i = 0;

    while ((!found) && (i < m_model->rowCount())) {
        found = m_model->value(i).toString() == value;

        if (found) {
            m_selector->setCurrentIndex(i);
        }

        i++;
    }

    if (!found) {
        m_selector->setCurrentIndex(0);
    }
}

QString MediaPlayerSelector::currentValue() {
    return m_model->value(m_selector->currentIndex()).toString();
}

void MediaPlayerSelector::onSelected() {
    emit valueChanged(currentValue());
}
