#ifndef LANGUAGESELECTOR_H
#define LANGUAGESELECTOR_H

#include "selectionmodels.h"
#include <QMaemo5ValueButton>
#include <QMaemo5ListPickSelector>

class LanguageSelector : public QMaemo5ValueButton
{
    Q_OBJECT

public:
    explicit LanguageSelector(const QString &text, bool hideUnavailable = false, QWidget *parent = 0);
    void setValue(const QString &value);
    QString currentValue();

private:
    void hideUnavailableLanguages();

private slots:
    void onSelected();

signals:
    void valueChanged(const QString &value);

private:
    LanguageModel *m_model;
    QMaemo5ListPickSelector *m_selector;
};

#endif // LANGUAGESELECTOR_H
