#ifndef GROUPITEM_H
#define GROUPITEM_H

#include <QObject>
#include <QUrl>
#include <QVariantMap>

class GroupItem : public QObject
{
    Q_OBJECT

public:
    explicit GroupItem(QObject *parent = 0): QObject(parent) {}
    explicit GroupItem(const QVariantMap &group, QObject *parent = 0);
    ~GroupItem() {}
    inline QString id() const { return m_id; }
    inline void setId(const QString &id) { m_id = id; }
    inline QString title() const { return m_title; }
    inline void setTitle(const QString &title) { m_title = title; }
    inline QString artist() const { return m_artist; }
    inline void setArtist(const QString &artist) { m_artist = artist; }
    inline QString artistId() const { return m_artistId; }
    inline void setArtistId(const QString &id) { m_artistId = id; }
    inline QUrl artistAvatarUrl() const { return m_artistAvatarUrl; }
    inline void setArtistAvatarUrl(const QUrl &url) { m_artistAvatarUrl = url; }
    inline QString description() const { return m_description; }
    inline void setDescription(const QString &description) { m_description = description; }
    inline QString date() const { return m_date; }
    inline void setDate(const QString &date) { m_date = date; }
    inline bool member() const { return m_member; }
    inline void setMember(bool member) { m_member = member; emit memberChanged(); }

signals:
    void memberChanged();

private:
    QString m_id;
    QString m_title;
    QString m_artist;
    QString m_artistId;
    QUrl m_artistAvatarUrl;
    QString m_description;
    QString m_date;
    bool m_member;
};

#endif // GROUPITEM_H
