#ifndef FACEBOOKAUTHDIALOG_H
#define FACEBOOKAUTHDIALOG_H

#include "abstractdialog.h"
#include "session.h"
#include "webview.h"
#include <QProgressBar>
#include <QGridLayout>

class FacebookAuthDialog : public AbstractDialog
{
    Q_OBJECT
public:
    explicit FacebookAuthDialog(Session *session, QWidget *parent = 0);

private:
    inline void setLandscapeLayout() { setFixedHeight(340); }
    inline void setPortraitLayout() { setFixedHeight(600); }

private slots:
    void checkUrlForToken(const QUrl &url);
        
private:
    Session *m_session;
    WebView *m_webView;
    QProgressBar *m_progressBar;
    QGridLayout *m_grid;
};

#endif // FACEBOOKAUTHDIALOG_H
