#ifndef DAILYMOTIONUSERPLAYLISTLISTMODEL_H
#define DAILYMOTIONUSERPLAYLISTLISTMODEL_H

#include "session.h"
#include <QAbstractListModel>

class DailymotionUserPlaylistListModel : public QAbstractListModel
{
    Q_OBJECT

public:
    enum Roles {

        IdRole = Qt::UserRole+1,
        PlaylistIdRole,
        TitleRole,
        ArtistRole,
        DateRole,
        VideoCountRole,
        DescriptionRole
    };

public:
    explicit DailymotionUserPlaylistListModel(Session *session, QObject *parent = 0);
    ~DailymotionUserPlaylistListModel() {}
    int rowCount(const QModelIndex &parent = QModelIndex()) const;
    QVariant data(const QModelIndex &index, int role = Qt::DisplayRole) const;
    inline QSharedPointer<PlaylistItem> get(int row) const { return m_session->dailymotion()->playlists()->at(row); }

private slots:
    void onPlaylistAdded(int row);
    void onPlaylistRemoved(int row);
    void onPlaylistUpdated(int row);

private:
    Session *m_session;
};

#endif // DAILYMOTIONUSERPLAYLISTLISTMODEL_H
