#ifndef DAILYMOTIONPRIVATEAUTHDIALOG_H
#define DAILYMOTIONPRIVATEAUTHDIALOG_H

#include "abstractdialog.h"
#include "session.h"
#include "webview.h"
#include <QProgressBar>
#include <QGridLayout>

class DailymotionPrivateAuthDialog : public AbstractDialog
{
    Q_OBJECT

public:
    explicit DailymotionPrivateAuthDialog(Session *session, QWidget *parent = 0);

private:
    inline void setLandscapeLayout() { setFixedHeight(340); }
    inline void setPortraitLayout() { setFixedHeight(600); }

private slots:
    void checkUrl(const QUrl &url);

private:
    CookieJar *m_jar;
    WebView *m_webView;
    QProgressBar *m_progressBar;
    QGridLayout *m_grid;
};

#endif // DAILYMOTIONPRIVATEAUTHDIALOG_H
