#ifndef DAILYMOTIONPLAYLISTVIDEOSWINDOW_H
#define DAILYMOTIONPLAYLISTVIDEOSWINDOW_H

#include "stackedwindow.h"
#include "dailymotionvideolistmodel.h"
#include "playlistitem.h"
#include "listview.h"
#include "thumbnaillabel.h"
#include "separatorlabel.h"
#include <QAction>
#include <QLabel>
#include <QScrollArea>

class DailymotionPlaylistVideosWindow : public StackedWindow
{
    Q_OBJECT
public:
    explicit DailymotionPlaylistVideosWindow(Session *session, QSharedPointer<PlaylistItem> playlist, QWidget *parent);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void setMenuActions();
    void onLoadingChanged();
    void addVideosToFavourites();
    void addVideosToPlaylist();
    void addVideoDownloads();
    void addAudioDownloads();
    void queueVideos();
    void showContextMenu(const QPoint &pos);
    void addVideoToFavourites();
    void showPlaylistDialog();
    void addVideoToPlaylist(const QString &id);
    void addVideoToNewPlaylist(const NewPlaylist &playlist);
    void addVideoDownload();
    void addAudioDownload();
    void queueVideo();
    void onItemClicked(const QModelIndex &index);
    void showVideoInfo(QSharedPointer<VideoItem> video);
    void playVideo(const QModelIndex &index);
    void showUserChannel();
    void setThumbnails();

private:
    QSharedPointer<PlaylistItem> m_playlist;
    ListView *m_listView;
    DailymotionVideoListModel *m_model;
    QAction *m_addToFavouritesAction;
    QAction *m_addToPlaylistAction;
    QAction *m_addToQueueAction;
    QAction *m_videoDownloadAction;
    QAction *m_audioDownloadAction;
    QMenu *m_contextMenu;
    QAction *m_addToFavouritesContextAction;
    QAction *m_addToPlaylistContextAction;
    QAction *m_addToQueueContextAction;
    QAction *m_videoDownloadContextAction;
    QAction *m_audioDownloadContextAction;
    QLabel *m_noResultsLabel;
    QLabel *m_titleLabel;
    QLabel *m_descriptionLabel;
    QLabel *m_dateLabel;
    ThumbnailLabel *m_thumbnail;
    ThumbnailLabel *m_avatar;
    SeparatorLabel *m_separator1;
    SeparatorLabel *m_separator2;
    QScrollArea *m_scrollArea;
};

#endif // DAILYMOTIONPLAYLISTVIDEOSWINDOW_H
